/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.util;

import com.aspectran.core.util.Assert;
import com.aspectran.web.support.util.HtmlCharacterEntityDecoder;
import com.aspectran.web.support.util.HtmlCharacterEntityReferences;

public abstract class HtmlUtils {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();

    public static String htmlEscape(String input) {
        return HtmlUtils.htmlEscape(input, DEFAULT_CHARACTER_ENCODING);
    }

    public static String htmlEscape(String input, String encoding) {
        Assert.notNull((Object)input, (String)"Input is required");
        Assert.notNull((Object)encoding, (String)"Encoding is required");
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            String reference = characterEntityReferences.convertToReference(character, encoding);
            if (reference != null) {
                escaped.append(reference);
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeDecimal(String input) {
        return HtmlUtils.htmlEscapeDecimal(input, DEFAULT_CHARACTER_ENCODING);
    }

    public static String htmlEscapeDecimal(String input, String encoding) {
        Assert.notNull((Object)input, (String)"Input is required");
        Assert.notNull((Object)encoding, (String)"Encoding is required");
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            if (characterEntityReferences.isMappedToReference(character, encoding)) {
                escaped.append("&#");
                escaped.append((int)character);
                escaped.append(';');
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeHex(String input) {
        return HtmlUtils.htmlEscapeHex(input, DEFAULT_CHARACTER_ENCODING);
    }

    public static String htmlEscapeHex(String input, String encoding) {
        Assert.notNull((Object)input, (String)"Input is required");
        Assert.notNull((Object)encoding, (String)"Encoding is required");
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            if (characterEntityReferences.isMappedToReference(character, encoding)) {
                escaped.append("&#x");
                escaped.append(Integer.toString(character, 16));
                escaped.append(';');
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlUnescape(String input) {
        return new HtmlCharacterEntityDecoder(characterEntityReferences, input).decode();
    }
}

