/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.util;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.util.StringUtils;
import java.io.IOException;

public class SendRedirectBasedOnXForwardedProtocol {
    private static final String SCHEME_DELIMITER = "://";

    public static void redirect(Translet translet, String location) throws IOException {
        translet.redirect(SendRedirectBasedOnXForwardedProtocol.getLocation(translet, location));
    }

    public static String getLocation(Translet translet, String location) {
        String forwarded = SendRedirectBasedOnXForwardedProtocol.getLocationForwarded(translet, location);
        return forwarded != null ? forwarded : location;
    }

    public static String getLocationForwarded(Translet translet, String location) {
        String host;
        String xForwardedProtocol = translet.getRequestAdapter().getHeader("X-Forwarded-Proto");
        if (StringUtils.hasLength((String)xForwardedProtocol) && StringUtils.hasLength((String)(host = translet.getRequestAdapter().getHeader("Host"))) && !SendRedirectBasedOnXForwardedProtocol.isAbsoluteUrl(location)) {
            return xForwardedProtocol + SCHEME_DELIMITER + host + location;
        }
        return null;
    }

    private static boolean isAbsoluteUrl(String location) {
        return location != null && location.toLowerCase().startsWith("http") && location.contains(SCHEME_DELIMITER);
    }
}

