/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.util;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.lang.Nullable;
import com.aspectran.core.util.Assert;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public abstract class WebUtils {
    public static final String ERROR_EXCEPTION_ATTRIBUTE = "javax.servlet.error.exception";

    @Nullable
    public static Cookie getCookie(HttpServletRequest request, String name) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    @Nullable
    public static Cookie getCookie(Translet translet, String name) {
        Assert.notNull((Object)translet, (String)"Translet must not be null");
        HttpServletRequest request = (HttpServletRequest)translet.getRequestAdapter().getAdaptee();
        return WebUtils.getCookie(request, name);
    }
}

