/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.view;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.dispatch.DispatchResponse;
import com.aspectran.core.activity.response.dispatch.ViewDispatcher;
import com.aspectran.core.activity.response.dispatch.ViewDispatcherException;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.web.activity.request.ActivityRequestWrapper;
import java.io.FileNotFoundException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class JspViewDispatcher
implements ViewDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(JspViewDispatcher.class);
    private static final String DEFAULT_CONTENT_TYPE = "text/html;charset=ISO-8859-1";
    private String contentType;
    private String prefix;
    private String suffix;

    public String getContentType() {
        return this.contentType != null ? this.contentType : "text/html";
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void dispatch(Activity activity, DispatchRule dispatchRule) throws ViewDispatcherException {
        String resource = null;
        try {
            resource = dispatchRule.getName(activity);
            if (resource == null) {
                throw new IllegalArgumentException("No specified dispatch name");
            }
            if (this.prefix != null && this.suffix != null) {
                resource = this.prefix + resource + this.suffix;
            } else if (this.prefix != null) {
                resource = this.prefix + resource;
            } else if (this.suffix != null) {
                resource = resource + this.suffix;
            }
            RequestAdapter requestAdapter = activity.getRequestAdapter();
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            String contentType = dispatchRule.getContentType();
            if (contentType != null) {
                responseAdapter.setContentType(contentType);
            } else {
                responseAdapter.setContentType(DEFAULT_CONTENT_TYPE);
            }
            String encoding = dispatchRule.getEncoding();
            if (encoding != null) {
                responseAdapter.setEncoding(encoding);
            } else if (responseAdapter.getEncoding() == null && (encoding = activity.getTranslet().getIntendedResponseEncoding()) != null) {
                responseAdapter.setEncoding(encoding);
            }
            ProcessResult processResult = activity.getProcessResult();
            DispatchResponse.saveAttributes((RequestAdapter)requestAdapter, (ProcessResult)processResult);
            HttpServletResponse response = (HttpServletResponse)responseAdapter.getAdaptee();
            if (response.isCommitted()) {
                response.reset();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Dispatching to JSP [" + resource + "]");
            }
            ActivityRequestWrapper requestWrapper = new ActivityRequestWrapper(activity);
            RequestDispatcher requestDispatcher = requestWrapper.getRequestDispatcher(resource);
            requestDispatcher.forward((ServletRequest)requestWrapper, (ServletResponse)response);
            if (response.getStatus() == 404) {
                throw new FileNotFoundException("Failed to find resource '" + resource + "'");
            }
        }
        catch (Exception e) {
            throw new ViewDispatcherException("Failed to dispatch to JSP " + dispatchRule.toString((ViewDispatcher)this, resource), (Throwable)e);
        }
    }

    public boolean isSingleton() {
        return true;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", (Object)super.toString());
        tsb.append("defaultContentType", (Object)this.contentType);
        tsb.append("prefix", (Object)this.prefix);
        tsb.append("suffix", (Object)this.suffix);
        return tsb.toString();
    }
}

