/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.freemarker.directive;

import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.freemarker.directive.AbstractTrimDirectiveModel;
import com.aspectran.freemarker.directive.TrimDirective;
import com.aspectran.freemarker.directive.Trimmer;
import freemarker.template.TemplateModelException;
import java.util.Map;

public class CustomTrimDirective
extends AbstractTrimDirectiveModel
implements TrimDirective {
    private final String groupName;
    private final String directiveName;
    private final Trimmer trimmer;

    public CustomTrimDirective(String groupName, String directiveName) {
        this(groupName, directiveName, null);
    }

    public CustomTrimDirective(String groupName, String directiveName, Trimmer trimmer) {
        this.groupName = groupName;
        this.directiveName = directiveName;
        this.trimmer = trimmer;
    }

    public CustomTrimDirective(String groupName, String directiveName, String prefix, String suffix, String[] deprefixes, String[] desuffixes, boolean caseSensitive) {
        this.groupName = groupName;
        this.directiveName = directiveName;
        Trimmer trimmer = new Trimmer();
        trimmer.setPrefix(prefix);
        trimmer.setSuffix(suffix);
        trimmer.setDeprefixes(deprefixes);
        trimmer.setDesuffixes(desuffixes);
        trimmer.setCaseSensitive(caseSensitive);
        this.trimmer = trimmer;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getDirectiveName() {
        return this.directiveName;
    }

    @Override
    protected Trimmer getTrimmer(Map params) throws TemplateModelException {
        if (this.trimmer == null) {
            String prefix = this.parseStringParameter(params, "prefix");
            String suffix = this.parseStringParameter(params, "suffix");
            String[] deprefixes = this.parseSequenceParameter(params, "deprefixes");
            String[] desuffixes = this.parseSequenceParameter(params, "desuffixes");
            String caseSensitive = this.parseStringParameter(params, "caseSensitive");
            Trimmer trimmer = new Trimmer();
            trimmer.setPrefix(prefix);
            trimmer.setSuffix(suffix);
            trimmer.setDeprefixes(deprefixes);
            trimmer.setDesuffixes(desuffixes);
            trimmer.setCaseSensitive(Boolean.parseBoolean(caseSensitive));
            return trimmer;
        }
        return this.trimmer;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("groupName", (Object)this.groupName);
        tsb.append("directiveName", (Object)this.directiveName);
        tsb.append("trimmer", (Object)this.trimmer);
        return tsb.toString();
    }
}

