/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.freemarker.view;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.dispatch.ViewDispatcher;
import com.aspectran.core.activity.response.dispatch.ViewDispatcherException;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.component.template.TemplateDataMap;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import freemarker.template.Configuration;
import freemarker.template.Template;

public class FreeMarkerViewDispatcher
implements ViewDispatcher {
    private static final Log log = LogFactory.getLog(FreeMarkerViewDispatcher.class);
    private final Configuration configuration;
    private String contentType;
    private String prefix;
    private String suffix;

    public FreeMarkerViewDispatcher(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void dispatch(Activity activity, DispatchRule dispatchRule) throws ViewDispatcherException {
        String dispatchName = null;
        try {
            String encoding;
            dispatchName = dispatchRule.getName(activity);
            if (dispatchName == null) {
                throw new IllegalArgumentException("No specified dispatch name");
            }
            if (this.prefix != null && this.suffix != null) {
                dispatchName = this.prefix + dispatchName + this.suffix;
            } else if (this.prefix != null) {
                dispatchName = this.prefix + dispatchName;
            } else if (this.suffix != null) {
                dispatchName = dispatchName + this.suffix;
            }
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            String contentType = dispatchRule.getContentType();
            if (contentType != null) {
                responseAdapter.setContentType(contentType);
            }
            if ((encoding = dispatchRule.getEncoding()) != null) {
                responseAdapter.setEncoding(encoding);
            } else if (responseAdapter.getEncoding() == null && (encoding = activity.getTranslet().getIntendedResponseEncoding()) != null) {
                responseAdapter.setEncoding(encoding);
            }
            if (log.isDebugEnabled()) {
                log.debug("Dispatching to FreeMarker template [" + dispatchName + "]");
            }
            TemplateDataMap model = new TemplateDataMap(activity);
            Template template = this.configuration.getTemplate(dispatchName);
            template.process((Object)model, responseAdapter.getWriter());
        }
        catch (Exception e) {
            throw new ViewDispatcherException("Failed to dispatch to FreeMarker template " + dispatchRule.toString((ViewDispatcher)this, dispatchName), (Throwable)e);
        }
    }

    public boolean isSingleton() {
        return true;
    }
}

