/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.freemarker;

import com.aspectran.core.component.template.engine.TemplateEngine;
import com.aspectran.core.component.template.engine.TemplateEngineProcessException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class FreeMarkerTemplateEngine
implements TemplateEngine {
    private final Configuration configuration;

    public FreeMarkerTemplateEngine(Configuration configuration) {
        this.configuration = configuration;
    }

    public void process(String templateName, Map<String, Object> model, String templateSource, Writer writer) throws TemplateEngineProcessException {
        try {
            StringReader reader = new StringReader(templateSource);
            Template template = new Template(templateName, (Reader)reader, this.configuration);
            template.process(model, writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new TemplateEngineProcessException((Throwable)e);
        }
    }

    public void process(String templateName, Map<String, Object> model, Writer writer) throws TemplateEngineProcessException {
        this.process(templateName, model, writer, null);
    }

    public void process(String templateName, Map<String, Object> model, Writer writer, Locale locale) throws TemplateEngineProcessException {
        try {
            Template template = this.configuration.getTemplate(templateName, locale);
            template.process(model, writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new TemplateEngineProcessException((Throwable)e);
        }
    }
}

