/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.freemarker.directive;

import com.aspectran.freemarker.directive.Trimmer;
import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractTrimDirectiveModel
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (body == null) {
            return;
        }
        if (loopVars.length != 0) {
            throw new TemplateModelException("Trim directive doesn't allow loop variables");
        }
        StringWriter bodyWriter = new StringWriter();
        body.render((Writer)bodyWriter);
        String trimmed = this.getTrimmer(params).trim(bodyWriter.toString());
        Writer out = env.getOut();
        out.write(trimmed);
    }

    protected abstract Trimmer getTrimmer(Map var1) throws TemplateModelException;

    protected String parseStringParameter(Map params, String paramName) {
        Object paramModel = params.get(paramName);
        if (paramModel == null) {
            return null;
        }
        if (!(paramModel instanceof SimpleScalar)) {
            throw new IllegalArgumentException(paramName + " must be string");
        }
        return ((SimpleScalar)paramModel).getAsString();
    }

    protected String[] parseSequenceParameter(Map params, String paramName) throws TemplateModelException {
        Object paramModel = params.get(paramName);
        if (paramModel == null) {
            return null;
        }
        if (!(paramModel instanceof SimpleSequence)) {
            throw new IllegalArgumentException(paramName + " must be sequence");
        }
        List<String> list = this.transformSimpleSequenceAsStringList((SimpleSequence)paramModel, paramName);
        return list.toArray(new String[0]);
    }

    private List<String> transformSimpleSequenceAsStringList(SimpleSequence sequence, String paramName) throws TemplateModelException {
        ArrayList<String> list = new ArrayList<String>();
        int size = sequence.size();
        for (int i = 0; i < size; ++i) {
            TemplateModel model = sequence.get(i);
            if (!(model instanceof SimpleScalar)) {
                throw new IllegalArgumentException(paramName + "'s item must be string");
            }
            list.add(((SimpleScalar)model).getAsString());
        }
        return list;
    }
}

