/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.freemarker.directive;

public class Trimmer {
    private String prefix;
    private String suffix;
    private String[] deprefixes;
    private String[] desuffixes;
    private boolean caseSensitive;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String[] getDeprefixes() {
        return this.deprefixes;
    }

    public void setDeprefixes(String[] deprefixes) {
        this.deprefixes = deprefixes;
    }

    public String[] getDesuffixes() {
        return this.desuffixes;
    }

    public void setDesuffixes(String[] desuffixes) {
        this.desuffixes = desuffixes;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String trim(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str);
        boolean deprefixed = this.deprefixing(builder);
        boolean desuffixed = this.desuffixing(builder);
        boolean prefixed = this.prefixing(builder);
        boolean sufixed = this.suffixing(builder);
        if (deprefixed || desuffixed || prefixed || sufixed) {
            return builder.toString();
        }
        return str.trim();
    }

    private boolean deprefixing(StringBuilder builder) {
        boolean applied = false;
        if (this.deprefixes != null && this.deprefixes.length > 0) {
            int start;
            for (start = 0; start < builder.length() && Character.isWhitespace(builder.charAt(start)); ++start) {
            }
            for (String deprefix : this.deprefixes) {
                if (!this.delete(deprefix, builder, start)) continue;
                applied = true;
            }
        }
        return applied;
    }

    private boolean desuffixing(StringBuilder builder) {
        boolean applied = false;
        if (this.desuffixes != null && this.desuffixes.length > 0) {
            int len;
            for (len = builder.length(); len > 0 && Character.isWhitespace(builder.charAt(len - 1)); --len) {
            }
            for (String desuffix : this.desuffixes) {
                int start = len - desuffix.length();
                if (!this.delete(desuffix, builder, start)) continue;
                applied = true;
            }
        }
        return applied;
    }

    private boolean prefixing(StringBuilder builder) {
        int start;
        if (this.prefix == null) {
            return false;
        }
        for (start = 0; start < builder.length() && Character.isWhitespace(builder.charAt(start)); ++start) {
        }
        builder.insert(start, this.prefix);
        return true;
    }

    private boolean suffixing(StringBuilder builder) {
        if (this.suffix == null) {
            return false;
        }
        builder.append(this.suffix);
        return true;
    }

    private boolean delete(String str, StringBuilder builder, int start) {
        if (str == null || str.length() > builder.length()) {
            return false;
        }
        int end = start + str.length();
        int i = start;
        int j = 0;
        while (i < end) {
            char c2;
            char c1 = this.caseSensitive ? builder.charAt(i) : Character.toLowerCase(builder.charAt(i));
            char c = c2 = this.caseSensitive ? str.charAt(j) : Character.toLowerCase(str.charAt(j));
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        builder.delete(start, end);
        return true;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("{prefix=").append(this.prefix);
        sb.append(", suffix=").append(this.suffix);
        sb.append(", deprefixes=");
        if (this.deprefixes != null) {
            sb.append("[");
            for (i = 0; i < this.deprefixes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.deprefixes[i]);
            }
            sb.append("]");
        } else {
            sb.append("null");
        }
        sb.append(", desuffixes=");
        if (this.desuffixes != null) {
            sb.append("[");
            for (i = 0; i < this.desuffixes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.desuffixes[i]);
            }
            sb.append("]");
        } else {
            sb.append("null");
        }
        sb.append(", caseSensitive=").append(this.caseSensitive);
        sb.append("}");
        return sb.toString();
    }
}

