/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.jetty;

import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServer
extends Server
implements InitializableBean,
DisposableBean {
    private static final Log log = LogFactory.getLog(JettyServer.class);
    private final Object monitor = new Object();
    private boolean autoStart;

    public JettyServer() {
    }

    public JettyServer(int port) {
        super(port);
    }

    public JettyServer(ThreadPool pool) {
        super(pool);
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public void initialize() throws Exception {
        this.start();
    }

    public void destroy() {
        try {
            this.stop();
        }
        catch (Exception e) {
            log.error("Error while stopping jetty server: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            if (this.autoStart) {
                log.info("Starting embedded Jetty server");
                super.doStart();
                log.info("Jetty started on port(s) " + this.getActualPortsDescription() + " with context path '" + this.getContextPath() + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() {
        Object object = this.monitor;
        synchronized (object) {
            log.info("Stopping embedded Jetty server");
            try {
                super.doStop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error("Unable to stop embedded Jetty server", (Throwable)e);
            }
        }
    }

    private String getContextPath() {
        HandlerContainer handlerContainer = (HandlerContainer)this.getHandler();
        return Arrays.stream(handlerContainer.getChildHandlers()).filter(ContextHandler.class::isInstance).map(ContextHandler.class::cast).map(ContextHandler::getContextPath).collect(Collectors.joining("', '"));
    }

    private String getActualPortsDescription() {
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.getConnectors()) {
            NetworkConnector connector1 = (NetworkConnector)connector;
            if (ports.length() != 0) {
                ports.append(", ");
            }
            ports.append(connector1.getLocalPort());
            ports.append(" (");
            ports.append(StringUtils.joinCommaDelimitedList((Collection)connector.getProtocols()));
            ports.append(")");
        }
        return ports.toString();
    }
}

