/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.jetty;

import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.web.service.AspectranWebService;
import com.aspectran.web.service.WebService;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.apache.jsp.JettyJasperInitializer;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyWebAppContext
extends WebAppContext
implements ActivityContextAware,
InitializableBean {
    private static final Log log = LogFactory.getLog(JettyWebAppContext.class);
    private ActivityContext context;
    private boolean standalone;

    public void setActivityContext(ActivityContext context) {
        this.context = context;
    }

    public void setTempDirectory(String tempDirectory) {
        File tempDir = null;
        try {
            tempDir = new File(tempDirectory);
            if (!tempDir.exists() && !tempDir.mkdirs()) {
                throw new IOException("Unable to create scratch directory: " + tempDir);
            }
            super.setTempDirectory(tempDir);
        }
        catch (Exception e) {
            log.error("Failed to establish Scratch directory: " + tempDir, (Throwable)e);
        }
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public void initialize() throws Exception {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        ClassLoader parent = this.context.getEnvironment().getClassLoader();
        WebAppClassLoader webAppClassLoader = new WebAppClassLoader(parent, (WebAppClassLoader.Context)this);
        this.setClassLoader((ClassLoader)webAppClassLoader);
        this.setAttribute("org.eclipse.jetty.containerInitializers", this.jspInitializers());
        this.setAttribute(InstanceManager.class.getName(), new SimpleInstanceManager());
        this.addBean(new ServletContainerInitializersStarter((WebAppContext)this), true);
        if (!this.standalone) {
            CoreService rootService = this.context.getRootService();
            AspectranWebService webService = AspectranWebService.create((ServletContext)this.getServletContext(), (CoreService)rootService);
            this.setAttribute(WebService.ROOT_WEB_SERVICE_ATTRIBUTE, webService);
        }
    }

    private List<ContainerInitializer> jspInitializers() {
        JettyJasperInitializer sci = new JettyJasperInitializer();
        ContainerInitializer initializer = new ContainerInitializer((ServletContainerInitializer)sci, null);
        return Collections.singletonList(initializer);
    }
}

