/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.mybatis;

import com.aspectran.core.activity.ActivityDataMap;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.mybatis.SqlSessionTxAdvice;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class SqlSessionAgent
implements SqlSession,
ActivityContextAware {
    private final String relevantAspectId;
    private ActivityContext context;
    private boolean autoParameters;

    public SqlSessionAgent(String relevantAspectId) {
        if (relevantAspectId == null) {
            throw new IllegalArgumentException("relevantAspectId can not be null");
        }
        this.relevantAspectId = relevantAspectId;
    }

    public void setAutoParameters(boolean autoParameters) {
        this.autoParameters = autoParameters;
    }

    public <T> T selectOne(String statement) {
        if (this.autoParameters) {
            return (T)this.getSqlSession().selectOne(statement, (Object)this.getActivityDataMap());
        }
        return (T)this.getSqlSession().selectOne(statement);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.getSqlSession().selectOne(statement, parameter);
    }

    public <E> List<E> selectList(String statement) {
        if (this.autoParameters) {
            return this.getSqlSession().selectList(statement, (Object)this.getActivityDataMap());
        }
        return this.getSqlSession().selectList(statement);
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.getSqlSession().selectList(statement, parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.getSqlSession().selectList(statement, parameter, rowBounds);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        if (this.autoParameters) {
            return this.getSqlSession().selectMap(statement, (Object)this.getActivityDataMap(), mapKey);
        }
        return this.getSqlSession().selectMap(statement, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.getSqlSession().selectMap(statement, parameter, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return this.getSqlSession().selectMap(statement, parameter, mapKey, rowBounds);
    }

    public <T> Cursor<T> selectCursor(String statement) {
        if (this.autoParameters) {
            return this.getSqlSession().selectCursor(statement, (Object)this.getActivityDataMap());
        }
        return this.getSqlSession().selectCursor(statement);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter) {
        return this.getSqlSession().selectCursor(statement, parameter);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter, RowBounds rowBounds) {
        return this.getSqlSession().selectCursor(statement, parameter, rowBounds);
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.getSqlSession().select(statement, parameter, handler);
    }

    public void select(String statement, ResultHandler handler) {
        if (this.autoParameters) {
            this.getSqlSession().select(statement, (Object)this.getActivityDataMap(), handler);
        } else {
            this.getSqlSession().select(statement, handler);
        }
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.getSqlSession().select(statement, parameter, rowBounds, handler);
    }

    public int insert(String statement) {
        if (this.autoParameters) {
            return this.getSqlSession().insert(statement, (Object)this.getActivityDataMap());
        }
        return this.getSqlSession().insert(statement);
    }

    public int insert(String statement, Object parameter) {
        return this.getSqlSession().insert(statement, parameter);
    }

    public int update(String statement) {
        if (this.autoParameters) {
            return this.getSqlSession().update(statement, (Object)this.getActivityDataMap());
        }
        return this.getSqlSession().update(statement);
    }

    public int update(String statement, Object parameter) {
        return this.getSqlSession().update(statement, parameter);
    }

    public int delete(String statement) {
        if (this.autoParameters) {
            return this.getSqlSession().delete(statement, (Object)this.getActivityDataMap());
        }
        return this.getSqlSession().delete(statement);
    }

    public int delete(String statement, Object parameter) {
        return this.getSqlSession().delete(statement, parameter);
    }

    public void commit() {
        this.getSqlSession().commit();
    }

    public void commit(boolean force) {
        this.getSqlSession().commit(force);
    }

    public void rollback() {
        this.getSqlSession().rollback();
    }

    public void rollback(boolean force) {
        this.getSqlSession().rollback(force);
    }

    public List<BatchResult> flushStatements() {
        return this.getSqlSession().flushStatements();
    }

    public void close() {
        this.getSqlSessionTxAdvice().close(true);
    }

    public void clearCache() {
        this.getSqlSession().clearCache();
    }

    public Configuration getConfiguration() {
        return this.getSqlSession().getConfiguration();
    }

    public <T> T getMapper(Class<T> type) {
        return (T)this.getSqlSession().getMapper(type);
    }

    public Connection getConnection() {
        return this.getSqlSession().getConnection();
    }

    @AvoidAdvice
    private SqlSession getSqlSession() {
        SqlSessionTxAdvice sqlSessionTxAdvice = this.getSqlSessionTxAdvice();
        SqlSession sqlSession = sqlSessionTxAdvice.getSqlSession();
        if (sqlSession == null) {
            if (sqlSessionTxAdvice.isArbitrarilyClosed()) {
                this.getSqlSessionTxAdvice().open();
                sqlSession = this.getSqlSessionTxAdvice().getSqlSession();
            } else {
                throw new IllegalArgumentException("SqlSession is not opened");
            }
        }
        return sqlSession;
    }

    @AvoidAdvice
    private SqlSessionTxAdvice getSqlSessionTxAdvice() {
        if (this.context == null) {
            throw new IllegalArgumentException("ActivityContext is not injected");
        }
        SqlSessionTxAdvice advice = (SqlSessionTxAdvice)this.context.getCurrentActivity().getAspectAdviceBean(this.relevantAspectId);
        if (advice == null) {
            if (this.context.getAspectRuleRegistry().getAspectRule(this.relevantAspectId) == null) {
                throw new IllegalArgumentException("Aspect '" + this.relevantAspectId + "' handling SqlSessionTxAdvice is undefined");
            }
            throw new IllegalArgumentException("SqlSessionTxAdvice is not defined");
        }
        return advice;
    }

    @AvoidAdvice
    public void setActivityContext(ActivityContext context) {
        this.context = context;
    }

    private ActivityDataMap getActivityDataMap() {
        if (this.context != null && this.context.getCurrentActivity().getTranslet() != null) {
            return this.context.getCurrentActivity().getTranslet().getActivityDataMap();
        }
        return null;
    }
}

