/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.mybatis;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.ablility.FactoryBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.util.ClassUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

@AvoidAdvice
public class SqlSessionFactoryBean
implements ApplicationAdapterAware,
InitializableBean,
FactoryBean<SqlSessionFactory> {
    private ApplicationAdapter applicationAdapter;
    private String configLocation;
    private String environment;
    private Properties properties;
    private SqlSessionFactory sqlSessionFactory;

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    /*
     * Loose catch block
     */
    protected SqlSessionFactory buildSqlSessionFactory(File configFile) {
        ClassLoader originalClassLoader = null;
        FileReader reader = new FileReader(configFile);
        originalClassLoader = ClassUtils.overrideThreadContextClassLoader((ClassLoader)this.applicationAdapter.getClassLoader());
        SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new SqlSessionFactoryBuilder();
        SqlSessionFactory sqlSessionFactory = sqlSessionFactoryBuilder.build((Reader)reader, this.environment, this.properties);
        ((Reader)reader).close();
        ClassUtils.restoreThreadContextClassLoader((ClassLoader)originalClassLoader);
        return sqlSessionFactory;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Failed to parse mybatis config resource: " + this.configLocation, ex);
                    }
                }
                catch (Throwable throwable3) {
                    ClassUtils.restoreThreadContextClassLoader(originalClassLoader);
                    throw throwable3;
                }
            }
        }
    }

    public void setApplicationAdapter(ApplicationAdapter applicationAdapter) {
        this.applicationAdapter = applicationAdapter;
    }

    public void initialize() throws Exception {
        if (this.applicationAdapter == null) {
            throw new IllegalStateException("applicationAdapter is not specified");
        }
        if (this.sqlSessionFactory == null) {
            if (this.configLocation == null) {
                throw new IllegalArgumentException("Property 'configLocation' is required");
            }
            File configFile = this.applicationAdapter.toRealPathAsFile(this.configLocation);
            this.sqlSessionFactory = this.buildSqlSessionFactory(configFile);
        }
    }

    public SqlSessionFactory getObject() {
        return this.sqlSessionFactory;
    }
}

