/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.mybatis;

import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class SqlSessionTxAdvice {
    private static final Log log = LogFactory.getLog(SqlSessionTxAdvice.class);
    private final SqlSessionFactory sqlSessionFactory;
    private ExecutorType executorType;
    private boolean autoCommit;
    private SqlSession sqlSession;
    private boolean arbitrarilyClosed;

    public SqlSessionTxAdvice(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setExecutorType(String executorType) {
        this.executorType = ExecutorType.valueOf((String)executorType);
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public void open() {
        if (this.sqlSession == null) {
            if (this.executorType == null) {
                this.executorType = ExecutorType.SIMPLE;
            }
            this.sqlSession = this.sqlSessionFactory.openSession(this.executorType, this.autoCommit);
            if (log.isDebugEnabled()) {
                ToStringBuilder tsb = new ToStringBuilder(String.format("%s %s@%x", this.arbitrarilyClosed ? "Reopened" : "Opened", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
                tsb.append("executorType", (Object)this.executorType);
                tsb.append("autoCommit", this.autoCommit);
                log.debug(tsb.toString());
            }
            this.arbitrarilyClosed = false;
        }
    }

    public void open(boolean autoCommit) {
        this.setAutoCommit(autoCommit);
        this.open();
    }

    public void open(String executorType) {
        this.setExecutorType(executorType);
        this.open();
    }

    public void open(String executorType, boolean autoCommit) {
        this.setExecutorType(executorType);
        this.setAutoCommit(autoCommit);
        this.open();
    }

    public void commit() {
        if (this.checkSession()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Committing transactional %s@%x", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
        }
        this.sqlSession.commit();
    }

    public void commit(boolean force) {
        if (this.checkSession()) {
            return;
        }
        if (log.isDebugEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder(String.format("Committing transactional %s@%x", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
            tsb.append("force", force);
            log.debug(tsb.toString());
        }
        this.sqlSession.commit(force);
    }

    public void rollback() {
        if (this.checkSession()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Rolling back transactional %s@%x", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
        }
        this.sqlSession.rollback();
    }

    public void rollback(boolean force) {
        if (this.checkSession()) {
            return;
        }
        if (log.isDebugEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder(String.format("Rolling back transactional %s@%x", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
            tsb.append("force", force);
            log.debug(tsb.toString());
        }
        this.sqlSession.rollback(force);
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean arbitrarily) {
        if (this.checkSession()) {
            return;
        }
        this.arbitrarilyClosed = arbitrarily;
        this.sqlSession.close();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Closed %s@%x", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
        }
        this.sqlSession = null;
    }

    public boolean isArbitrarilyClosed() {
        return this.arbitrarilyClosed;
    }

    private boolean checkSession() {
        if (this.arbitrarilyClosed) {
            return true;
        }
        if (this.sqlSession == null) {
            throw new IllegalStateException("SqlSession is not open");
        }
        return false;
    }
}

