/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.mybatis;

import com.aspectran.utils.Assert;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class SqlSessionTxAdvice {
    private static final Logger logger = LoggerFactory.getLogger(SqlSessionTxAdvice.class);
    private final SqlSessionFactory sqlSessionFactory;
    private ExecutorType executorType;
    private boolean autoCommit;
    private SqlSession sqlSession;
    private boolean arbitrarilyClosed;

    public SqlSessionTxAdvice(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        Assert.state((this.sqlSession == null ? 1 : 0) != 0, (String)"Sql Session is already open");
        this.autoCommit = autoCommit;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public void setExecutorType(ExecutorType executorType) {
        Assert.state((this.sqlSession == null ? 1 : 0) != 0, (String)"Sql Session is already open");
        this.executorType = executorType;
    }

    public void setExecutorType(String executorType) {
        this.setExecutorType(ExecutorType.valueOf((String)executorType));
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public void open() {
        if (this.sqlSession == null) {
            if (this.executorType == null) {
                this.executorType = ExecutorType.SIMPLE;
            }
            this.sqlSession = this.sqlSessionFactory.openSession(this.executorType, this.autoCommit);
            if (logger.isDebugEnabled()) {
                ToStringBuilder tsb = new ToStringBuilder(String.format("%s %s@%x", this.arbitrarilyClosed ? "Reopen" : "Open", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
                tsb.append("executorType", (Object)this.executorType);
                tsb.append("autoCommit", this.autoCommit);
                logger.debug(tsb.toString());
            }
            this.arbitrarilyClosed = false;
        }
    }

    public void open(boolean autoCommit) {
        this.setAutoCommit(autoCommit);
        this.open();
    }

    public void open(ExecutorType executorType) {
        this.setExecutorType(executorType);
        this.open();
    }

    public void open(ExecutorType executorType, boolean autoCommit) {
        this.setExecutorType(executorType);
        this.setAutoCommit(autoCommit);
        this.open();
    }

    public void open(String executorType) {
        this.setExecutorType(executorType);
        this.open();
    }

    public void open(String executorType, boolean autoCommit) {
        this.setExecutorType(executorType);
        this.setAutoCommit(autoCommit);
        this.open();
    }

    public void commit() {
        if (this.checkSession()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Commit transaction for %s@%x", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
        }
        this.sqlSession.commit();
    }

    public void commit(boolean force) {
        if (this.checkSession()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder(String.format("Commit transaction for %s@%x", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
            tsb.append("force", force);
            logger.debug(tsb.toString());
        }
        this.sqlSession.commit(force);
    }

    public void rollback() {
        if (this.checkSession()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Rollback transaction for %s@%x", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
        }
        this.sqlSession.rollback();
    }

    public void rollback(boolean force) {
        if (this.checkSession()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder(String.format("Rollback transaction for %s@%x", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
            tsb.append("force", force);
            logger.debug(tsb.toString());
        }
        this.sqlSession.rollback(force);
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean arbitrarily) {
        if (this.checkSession()) {
            return;
        }
        this.arbitrarilyClosed = arbitrarily;
        this.sqlSession.close();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Close %s@%x", this.sqlSession.getClass().getSimpleName(), this.sqlSession.hashCode()));
        }
        this.sqlSession = null;
    }

    public boolean isArbitrarilyClosed() {
        return this.arbitrarilyClosed;
    }

    private boolean checkSession() {
        if (this.arbitrarilyClosed) {
            return true;
        }
        if (this.sqlSession == null) {
            throw new IllegalStateException("SqlSession is not open");
        }
        return false;
    }
}

