/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.pebble;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.DelegatingLoader;
import com.mitchellbosecke.pebble.loader.FileLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.loader.StringLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class PebbleEngineFactory
implements ApplicationAdapterAware {
    private static final Log log = LogFactory.getLog(PebbleEngineFactory.class);
    private ApplicationAdapter applicationAdapter;
    private Locale defaultLocale;
    private boolean strictVariables;
    private String[] templateLoaderPaths;
    private Loader<?>[] templateLoaders;

    public void setApplicationAdapter(ApplicationAdapter applicationAdapter) {
        this.applicationAdapter = applicationAdapter;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = StringUtils.parseLocaleString((String)defaultLocale);
    }

    public void setStrictVariables(boolean strictVariables) {
        this.strictVariables = strictVariables;
    }

    public void setTemplateLoaderPath(String templateLoaderPath) {
        this.templateLoaderPaths = new String[]{templateLoaderPath};
    }

    public void setTemplateLoaderPath(String[] templateLoaderPaths) {
        this.templateLoaderPaths = templateLoaderPaths;
    }

    public void setTemplateLoaderPath(List<String> templateLoaderPathList) {
        this.templateLoaderPaths = templateLoaderPathList.toArray(new String[0]);
    }

    public void setTemplateLoader(Loader<?> templateLoaders) {
        this.templateLoaders = new Loader[]{templateLoaders};
    }

    public void setTemplateLoader(Loader<?>[] templateLoaders) {
        this.templateLoaders = templateLoaders;
    }

    public void setTemplateLoader(List<Loader<?>> templateLoaderList) {
        this.templateLoaders = templateLoaderList.toArray(new Loader[0]);
    }

    public PebbleEngine createPebbleEngine() {
        PebbleEngine.Builder builder = new PebbleEngine.Builder();
        builder.strictVariables(this.strictVariables);
        if (this.defaultLocale != null) {
            builder.defaultLocale(this.defaultLocale);
        }
        if (this.templateLoaders == null && this.templateLoaderPaths != null && this.templateLoaderPaths.length > 0) {
            ArrayList templateLoaderList = new ArrayList();
            for (String path : this.templateLoaderPaths) {
                templateLoaderList.add(this.getTemplateLoaderForPath(path));
            }
            this.setTemplateLoader(templateLoaderList);
        }
        Loader<?> templateLoader = this.getAggregateTemplateLoader(this.templateLoaders);
        builder.loader(templateLoader);
        return builder.build();
    }

    protected Loader<?> getAggregateTemplateLoader(Loader<?>[] templateLoaders) {
        int loaderCount = templateLoaders == null ? 0 : templateLoaders.length;
        switch (loaderCount) {
            case 0: {
                StringLoader stringLoader = new StringLoader();
                if (log.isDebugEnabled()) {
                    log.debug("Pebble Engine Template Loader not specified. Default Template Loader registered: " + stringLoader);
                }
                return stringLoader;
            }
            case 1: {
                if (log.isDebugEnabled()) {
                    log.debug("One Pebble Engine Template Loader registered: " + templateLoaders[0]);
                }
                return templateLoaders[0];
            }
        }
        ArrayList defaultLoadingStrategies = new ArrayList();
        Collections.addAll(defaultLoadingStrategies, templateLoaders);
        DelegatingLoader delegatingLoader = new DelegatingLoader(defaultLoadingStrategies);
        if (log.isDebugEnabled()) {
            log.debug("Multiple Pebble Engine Template Loader registered: " + delegatingLoader);
        }
        return delegatingLoader;
    }

    protected Loader<?> getTemplateLoaderForPath(String templateLoaderPath) {
        if (templateLoaderPath.startsWith("classpath:")) {
            String basePackagePath = templateLoaderPath.substring("classpath:".length());
            if (log.isDebugEnabled()) {
                log.debug("Template loader path [" + templateLoaderPath + "] resolved to class path [" + basePackagePath + "]");
            }
            ClasspathLoader loader = new ClasspathLoader(this.applicationAdapter.getClassLoader());
            loader.setPrefix(basePackagePath);
            return loader;
        }
        if (templateLoaderPath.startsWith("file:")) {
            File file = new File(templateLoaderPath.substring("file:".length()));
            String prefix = file.getAbsolutePath();
            if (log.isDebugEnabled()) {
                log.debug("Template loader path [" + templateLoaderPath + "] resolved to file path [" + prefix + "]");
            }
            FileLoader loader = new FileLoader();
            loader.setPrefix(prefix);
            return loader;
        }
        File file = new File(this.applicationAdapter.getBasePath(), templateLoaderPath);
        String prefix = file.getAbsolutePath();
        if (log.isDebugEnabled()) {
            log.debug("Template loader path [" + templateLoaderPath + "] resolved to file path [" + prefix + "]");
        }
        FileLoader loader = new FileLoader();
        loader.setPrefix(prefix);
        return loader;
    }
}

