/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.adapter;

import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.adapter.AbstractRequestAdapter;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.MultiValueMap;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.web.activity.request.WebRequestBodyParser;
import com.aspectran.web.support.http.MediaType;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.LocaleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TowRequestAdapter
extends AbstractRequestAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TowRequestAdapter.class);
    private boolean headersObtained;
    private boolean encodingObtained;
    private boolean bodyObtained;
    private MediaType mediaType;

    public TowRequestAdapter(MethodType requestMethod, HttpServerExchange exchange) {
        super(requestMethod, (Object)exchange);
    }

    public MultiValueMap<String, String> getHeaderMap() {
        if (!this.headersObtained) {
            this.headersObtained = true;
            if (this.getHttpServerExchange().getRequestHeaders().size() > 0) {
                MultiValueMap multiValueMap = super.getHeaderMap();
                for (HeaderValues headerValues : this.getHttpServerExchange().getRequestHeaders()) {
                    String name = headerValues.getHeaderName().toString();
                    for (String value : headerValues) {
                        multiValueMap.add((Object)name, (Object)value);
                    }
                }
            }
        }
        return super.getHeaderMap();
    }

    public String getEncoding() {
        if (!this.encodingObtained) {
            this.encodingObtained = true;
            String contentType = this.getHttpServerExchange().getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
            if (contentType == null) {
                return null;
            }
            return Headers.extractQuotedValueFromHeader((String)contentType, (String)"charset");
        }
        return super.getEncoding();
    }

    public InputStream getInputStream() throws IOException {
        return this.getHttpServerExchange().getInputStream();
    }

    public String getBody() {
        if (!this.bodyObtained) {
            this.bodyObtained = true;
            try {
                String body = WebRequestBodyParser.parseBody((InputStream)this.getInputStream(), (String)this.getEncoding(), (long)this.getMaxRequestSize());
                this.setBody(body);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to parse request body", (Throwable)e);
                }
                this.setBody(null);
            }
        }
        return super.getBody();
    }

    public <T extends Parameters> T getBodyAsParameters(Class<T> requiredType) throws RequestParseException {
        if (this.getMediaType() != null) {
            return (T)WebRequestBodyParser.parseBodyAsParameters((RequestAdapter)this, (MediaType)this.getMediaType(), requiredType);
        }
        return null;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    private void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    private HttpServerExchange getHttpServerExchange() {
        return (HttpServerExchange)this.getAdaptee();
    }

    public void preparse() {
        String acceptLanguage;
        List locales;
        HttpServerExchange exchange = (HttpServerExchange)this.getAdaptee();
        for (Map.Entry entry : exchange.getQueryParameters().entrySet()) {
            String name = (String)entry.getKey();
            String[] values = ((Deque)entry.getValue()).toArray(new String[0]);
            this.getParameterMap().put((Object)name, (Object)values);
        }
        String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType != null) {
            this.setMediaType(MediaType.parseMediaType((String)contentType));
        }
        if (!(locales = LocaleUtils.getLocalesFromHeader((String)(acceptLanguage = exchange.getRequestHeaders().getFirst(Headers.ACCEPT_LANGUAGE)))).isEmpty()) {
            this.setLocale((Locale)locales.get(0));
        }
    }

    public void preparse(TowRequestAdapter requestAdapter) {
        this.getParameterMap().putAll((Map)requestAdapter.getParameterMap());
        this.setAttributeMap(requestAdapter.getAttributeMap());
        this.setMediaType(requestAdapter.getMediaType());
        this.setLocale(requestAdapter.getLocale());
    }
}

