/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.adapter;

import com.aspectran.core.adapter.AbstractSessionAdapter;
import com.aspectran.core.component.bean.scope.SessionScope;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import java.util.Collections;
import java.util.Enumeration;

public class TowSessionAdapter
extends AbstractSessionAdapter {
    private boolean newSession;

    public TowSessionAdapter(HttpServerExchange exchange) {
        super((Object)exchange);
    }

    public <T> T getAdaptee() {
        return (T)this.getSession(true);
    }

    public SessionScope newSessionScope() {
        return new SessionScope();
    }

    public String getId() {
        return this.getSession(true).getId();
    }

    public long getCreationTime() {
        return this.getSession(true).getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.getSession(true).getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.getSession(true).getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int interval) {
        this.getSession(true).setMaxInactiveInterval(interval);
    }

    public Enumeration<String> getAttributeNames() {
        Session session = this.getSession(false);
        if (session != null) {
            return Collections.enumeration(session.getAttributeNames());
        }
        return null;
    }

    public <T> T getAttribute(String name) {
        Session session = this.getSession(false);
        if (session != null) {
            return (T)session.getAttribute(name);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            Session session = this.getSession(true);
            session.setAttribute(name, value);
        } else {
            Session session = this.getSession(false);
            if (session != null) {
                session.removeAttribute(name);
            }
        }
    }

    public void removeAttribute(String name) {
        Session session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }

    public void invalidate() {
        Session session = this.getSession(false);
        if (session != null) {
            session.invalidate((HttpServerExchange)this.getAdaptee());
        }
    }

    public boolean isNew() {
        Session session = this.getSession(false);
        if (session == null) {
            return true;
        }
        return this.newSession;
    }

    public Session getSession(boolean create) {
        HttpServerExchange exchange = (HttpServerExchange)super.getAdaptee();
        SessionManager sm = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
        SessionConfig sc = (SessionConfig)exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
        if (sc == null || sm == null) {
            return null;
        }
        Session session = sm.getSession(exchange, sc);
        if (session == null && create) {
            this.newSession = true;
            return sm.createSession(exchange, sc);
        }
        return session;
    }
}

