/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server;

import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.util.lifecycle.AbstractLifeCycle;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.undertow.server.AjpListenerConfig;
import com.aspectran.undertow.server.HttpListenerConfig;
import com.aspectran.undertow.server.HttpsListenerConfig;
import com.aspectran.undertow.server.TowOptions;
import io.undertow.Undertow;
import io.undertow.Version;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import java.io.IOException;
import org.xnio.Option;
import org.xnio.OptionMap;

public class TowServer
extends AbstractLifeCycle
implements InitializableBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(TowServer.class);
    private final Undertow.Builder builder = Undertow.builder();
    private boolean autoStart;
    private int shutdownTimeout;
    private ServletContainer servletContainer;
    private HttpHandler handler;
    private Undertow server;

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public void setHttpListeners(HttpListenerConfig ... httpListenerConfigs) {
        if (httpListenerConfigs == null) {
            throw new IllegalArgumentException("httpListenerConfigs must not be null");
        }
        for (HttpListenerConfig listenerConfig : httpListenerConfigs) {
            this.builder.addListener(listenerConfig.getListenerBuilder());
        }
    }

    public void setHttpsListeners(HttpsListenerConfig ... httpsListenerConfigs) throws IOException {
        if (httpsListenerConfigs == null) {
            throw new IllegalArgumentException("httpsListenerConfigs must not be null");
        }
        for (HttpsListenerConfig listenerConfig : httpsListenerConfigs) {
            this.builder.addListener(listenerConfig.getListenerBuilder());
        }
    }

    public void setAjpListeners(AjpListenerConfig ... ajpListenerConfigs) {
        if (ajpListenerConfigs == null) {
            throw new IllegalArgumentException("ajpListenerConfigs must not be null");
        }
        for (AjpListenerConfig listenerConfig : ajpListenerConfigs) {
            this.builder.addListener(listenerConfig.getListenerBuilder());
        }
    }

    public void setHandler(HttpHandler handler) {
        this.handler = handler;
        this.builder.setHandler(handler);
    }

    public void setBufferSize(int bufferSize) {
        this.builder.setBufferSize(bufferSize);
    }

    public void setIoThreads(int ioThreads) {
        this.builder.setIoThreads(ioThreads);
    }

    public void setWorkerThreads(int workerThreads) {
        this.builder.setWorkerThreads(workerThreads);
    }

    public void setDirectBuffers(boolean directBuffers) {
        this.builder.setDirectBuffers(directBuffers);
    }

    public <T> void setServerOption(Option<T> option, T value) {
        this.builder.setServerOption(option, value);
    }

    public <T> void setSocketOption(Option<T> option, T value) {
        this.builder.setSocketOption(option, value);
    }

    public <T> void setWorkerOption(Option<T> option, T value) {
        this.builder.setWorkerOption(option, value);
    }

    public Undertow.Builder getBuilder() {
        return this.builder;
    }

    public void setServerOptions(TowOptions options) {
        if (options != null) {
            OptionMap optionMap = options.getOptionMap();
            for (Option option : optionMap) {
                this.builder.setServerOption(option, optionMap.get(option));
            }
        }
    }

    public void setSocketOptions(TowOptions options) {
        if (options != null) {
            OptionMap optionMap = options.getOptionMap();
            for (Option option : optionMap) {
                this.builder.setSocketOption(option, optionMap.get(option));
            }
        }
    }

    public void setWorkerOptions(TowOptions options) {
        if (options != null) {
            OptionMap optionMap = options.getOptionMap();
            for (Option option : optionMap) {
                this.builder.setWorkerOption(option, optionMap.get(option));
            }
        }
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public void setServletContainer(ServletContainer servletContainer) {
        this.servletContainer = servletContainer;
    }

    public void doStart() throws Exception {
        try {
            this.server = this.builder.build();
            this.server.start();
            logger.info("Undertow " + Version.getVersionString() + " started");
        }
        catch (Exception e) {
            try {
                if (this.server != null) {
                    this.server.stop();
                    this.server = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("Unable to start Undertow server", e);
        }
    }

    public void doStop() {
        block10: {
            try {
                if (this.server == null) break block10;
                if (this.handler instanceof GracefulShutdownHandler) {
                    ((GracefulShutdownHandler)this.handler).shutdown();
                    try {
                        if (this.shutdownTimeout > 0) {
                            boolean result = ((GracefulShutdownHandler)this.handler).awaitShutdown((long)this.shutdownTimeout * 1000L);
                            if (!result) {
                                logger.warn("Undertow server did not shut down gracefully within " + this.shutdownTimeout + " seconds. Proceeding with forceful shutdown");
                            }
                        } else {
                            ((GracefulShutdownHandler)this.handler).awaitShutdown();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Unable to gracefully stop Undertow server");
                    }
                }
                if (this.servletContainer != null) {
                    for (String deploymentName : this.servletContainer.listDeployments()) {
                        DeploymentManager manager = this.servletContainer.getDeployment(deploymentName);
                        manager.stop();
                        manager.undeploy();
                    }
                }
                this.server.stop();
                this.server = null;
                logger.info("Undertow " + Version.getVersionString() + " stopped");
            }
            catch (Exception e) {
                logger.error("Unable to stop Undertow server", (Throwable)e);
            }
        }
    }

    public void initialize() throws Exception {
        if (this.autoStart) {
            this.start();
        }
    }

    public void destroy() {
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.error("Error while stopping Undertow server: " + e.getMessage(), (Throwable)e);
        }
    }
}

