/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.encoding;

import com.aspectran.web.support.http.MediaType;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.RequestHeaderAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class EncodingHandlerWrapper
implements HandlerWrapper {
    private static final String GZIP = "gzip";
    private static final String DEFLATE = "deflate";
    private String[] contentEncodingProviderNames;
    private long maxContentSize = 2048L;
    private String[] mediaTypes;
    private String[] excludedUserAgents;

    public void setContentEncodingProviders(String ... contentEncodingProviderNames) {
        this.contentEncodingProviderNames = contentEncodingProviderNames;
    }

    public void setMaxContentSize(long maxContentSize) {
        this.maxContentSize = maxContentSize;
    }

    public void setMediaTypes(String[] mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public void setExcludedUserAgents(String[] excludedUserAgents) {
        this.excludedUserAgents = excludedUserAgents;
    }

    public HttpHandler wrap(HttpHandler handler) {
        ContentEncodingRepository contentEncodingRepository = new ContentEncodingRepository();
        if (this.contentEncodingProviderNames != null && this.contentEncodingProviderNames.length != 0) {
            LinkedHashSet<String> names = new LinkedHashSet<String>(Arrays.asList(this.contentEncodingProviderNames));
            Predicate predicate = Predicates.and((Predicate[])this.getCompressionPredicates());
            int priority = 100;
            for (String name : names) {
                if (GZIP.equalsIgnoreCase(name)) {
                    contentEncodingRepository.addEncodingHandler(GZIP, (ContentEncodingProvider)new GzipEncodingProvider(), priority, predicate);
                } else if (DEFLATE.equalsIgnoreCase(name)) {
                    contentEncodingRepository.addEncodingHandler(DEFLATE, (ContentEncodingProvider)new DeflateEncodingProvider(), priority, predicate);
                } else {
                    throw new IllegalArgumentException("Unknown content encoding provider '" + name + "'");
                }
                priority /= 10;
            }
        }
        return new EncodingHandler(handler, contentEncodingRepository);
    }

    private Predicate[] getCompressionPredicates() {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (this.maxContentSize > 0L) {
            predicates.add(Predicates.requestLargerThan((long)this.maxContentSize));
        }
        if (this.mediaTypes != null && this.mediaTypes.length > 0) {
            predicates.add(new CompressibleMimeTypePredicate(this.mediaTypes));
        }
        if (this.excludedUserAgents != null && this.excludedUserAgents.length > 0) {
            for (String agent : this.excludedUserAgents) {
                RequestHeaderAttribute agentHeader = new RequestHeaderAttribute(new HttpString("User-Agent"));
                predicates.add(Predicates.not((Predicate)Predicates.regex((ExchangeAttribute)agentHeader, (String)agent)));
            }
        }
        return predicates.toArray(new Predicate[0]);
    }

    private static class CompressibleMimeTypePredicate
    implements Predicate {
        private final List<MediaType> mediaTypes;

        private CompressibleMimeTypePredicate(String[] mediaTypes) {
            if (mediaTypes.length == 1) {
                this.mediaTypes = Collections.singletonList(MediaType.parseMediaType((String)mediaTypes[0]));
            } else {
                this.mediaTypes = new ArrayList<MediaType>(mediaTypes.length);
                for (String mediaType : mediaTypes) {
                    this.mediaTypes.add(MediaType.parseMediaType((String)mediaType));
                }
            }
        }

        public boolean resolve(HttpServerExchange exchange) {
            String contentType = exchange.getResponseHeaders().getFirst("Content-Type");
            if (contentType != null) {
                for (MediaType mediaType : this.mediaTypes) {
                    if (!mediaType.isCompatibleWith(MediaType.parseMediaType((String)contentType))) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

