/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.http;

import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.util.Assert;
import com.aspectran.core.util.lifecycle.LifeCycle;
import com.aspectran.undertow.server.TowServer;
import com.aspectran.undertow.server.http.HttpHybridHandler;
import com.aspectran.undertow.server.resource.StaticResourceHandler;
import com.aspectran.undertow.service.DefaultTowService;
import com.aspectran.undertow.service.TowService;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import java.util.Arrays;
import java.util.List;

public class HttpHybridHandlerFactory
implements ActivityContextAware,
DisposableBean {
    private ActivityContext context;
    private TowServer towServer;
    private ResourceManager resourceManager;
    private StaticResourceHandler staticResourceHandler;
    private SessionManager sessionManager;
    private SessionConfig sessionConfig;
    private List<HandlerWrapper> outerHandlerChainWrappers;
    private AspectranConfig aspectranConfig;
    private TowService towService;

    @AvoidAdvice
    public void setActivityContext(ActivityContext context) {
        this.context = context;
    }

    public void setTowServer(TowServer towServer) {
        this.towServer = towServer;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setStaticResourceHandler(StaticResourceHandler staticResourceHandler) {
        this.staticResourceHandler = staticResourceHandler;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public void setOuterHandlerChainWrappers(HandlerWrapper[] wrappers) {
        this.outerHandlerChainWrappers = wrappers != null && wrappers.length > 0 ? Arrays.asList(wrappers) : null;
    }

    public void setAspectranConfig(AspectranConfig aspectranConfig) {
        this.aspectranConfig = aspectranConfig;
    }

    public HttpHandler createHandler() {
        TowService towService = this.createTowService();
        if (this.sessionManager != null) {
            if (this.sessionConfig == null) {
                this.setSessionConfig((SessionConfig)new SessionCookieConfig());
            }
            this.sessionManager.start();
        }
        HttpHybridHandler httpHybridHandler = new HttpHybridHandler(this.resourceManager);
        httpHybridHandler.setStaticResourceHandler(this.staticResourceHandler);
        httpHybridHandler.setSessionManager(this.sessionManager);
        httpHybridHandler.setSessionConfig(this.sessionConfig);
        httpHybridHandler.setTowService(towService);
        if (this.outerHandlerChainWrappers != null) {
            return HttpHybridHandlerFactory.wrapHandlers((HttpHandler)httpHybridHandler, this.outerHandlerChainWrappers);
        }
        return httpHybridHandler;
    }

    private TowService createTowService() {
        Assert.state((this.towService == null ? 1 : 0) != 0, (String)"TowService is already configured");
        if (this.aspectranConfig == null) {
            this.towService = DefaultTowService.create(this.context.getRootService());
        } else {
            String basePath;
            ContextConfig contextConfig = this.aspectranConfig.getContextConfig();
            if (contextConfig != null && (basePath = contextConfig.getBasePath()) == null) {
                contextConfig.setBasePath(this.context.getApplicationAdapter().getBasePath());
            }
            this.towService = DefaultTowService.create(this.aspectranConfig);
        }
        if (this.towServer != null) {
            this.towServer.addLifeCycleListener(new LifeCycle.Listener(){

                public void lifeCycleStopping(LifeCycle event) {
                    HttpHybridHandlerFactory.this.destroyTowService();
                }
            });
        }
        return this.towService;
    }

    private void destroyTowService() {
        if (this.towService != null) {
            if (this.towService.getServiceController().isActive()) {
                this.towService.getServiceController().stop();
                if (this.towService.isDerived()) {
                    this.towService.leaveFromRootService();
                }
            }
            this.towService = null;
        }
    }

    public void destroy() throws Exception {
        this.destroyTowService();
        if (this.sessionManager != null) {
            this.sessionManager.stop();
        }
    }

    private static HttpHandler wrapHandlers(HttpHandler wrapee, List<HandlerWrapper> wrappers) {
        HttpHandler current = wrapee;
        for (HandlerWrapper wrapper : wrappers) {
            current = wrapper.wrap(current);
        }
        return current;
    }
}

