/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.resource;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.util.StringUtils;
import io.undertow.server.handlers.resource.PathResourceManager;
import java.io.File;
import java.io.IOException;

public class TowResourceManager
extends PathResourceManager
implements ApplicationAdapterAware {
    private ApplicationAdapter applicationAdapter;

    public TowResourceManager() {
        this(1024L, true, false, (String[])null);
    }

    public TowResourceManager(File base) {
        this(base, 1024L, true, false, (String[])null);
    }

    public TowResourceManager(File base, long transferMinSize) {
        this(base, transferMinSize, true, false, (String[])null);
    }

    public TowResourceManager(File base, long transferMinSize, boolean caseSensitive) {
        this(base, transferMinSize, caseSensitive, false, (String[])null);
    }

    public TowResourceManager(File base, long transferMinSize, boolean followLinks, String ... safePaths) {
        this(base, transferMinSize, true, followLinks, safePaths);
    }

    protected TowResourceManager(long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        super(transferMinSize, caseSensitive, followLinks, safePaths);
    }

    public TowResourceManager(File base, long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        super(base.toPath(), transferMinSize, caseSensitive, followLinks, safePaths);
    }

    public void setApplicationAdapter(ApplicationAdapter applicationAdapter) {
        this.applicationAdapter = applicationAdapter;
    }

    public String getBase() {
        return super.getBasePath().toString();
    }

    public void setBase(String base) throws IOException {
        if (!StringUtils.hasText((String)base)) {
            throw new IllegalArgumentException("Resource base path must not be null or empty");
        }
        if (this.applicationAdapter != null) {
            this.setBase(this.applicationAdapter.toRealPathAsFile(base));
        } else {
            this.setBase(new File(base));
        }
    }

    public TowResourceManager setBase(File base) {
        if (base == null) {
            throw new IllegalArgumentException("Resource base path must not be null");
        }
        if (!base.isDirectory()) {
            throw new IllegalArgumentException("Resource base path '" + base + "' does not exist");
        }
        super.setBase(base);
        return this;
    }
}

