/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.core.util.Assert;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public class ServletHybridHandler
implements HttpHandler {
    private final HttpHandler defaultHandler;
    private final HttpHandler staticResourceHandler;

    public ServletHybridHandler(HttpHandler defaultHandler) {
        this(defaultHandler, null);
    }

    public ServletHybridHandler(HttpHandler defaultHandler, HttpHandler staticResourceHandler) {
        Assert.notNull((Object)defaultHandler, (String)"defaultHandler must not be null");
        this.defaultHandler = defaultHandler;
        this.staticResourceHandler = staticResourceHandler;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.staticResourceHandler != null) {
            this.staticResourceHandler.handleRequest(exchange);
            if (!exchange.isDispatched() && !exchange.isComplete()) {
                this.defaultHandler.handleRequest(exchange);
            }
        } else {
            this.defaultHandler.handleRequest(exchange);
        }
    }
}

