/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.service.CoreService;
import com.aspectran.undertow.server.resource.StaticResourceHandler;
import com.aspectran.undertow.server.servlet.ServletHybridHandler;
import com.aspectran.undertow.server.servlet.TowServletContext;
import com.aspectran.web.service.DefaultWebService;
import com.aspectran.web.service.WebService;
import com.aspectran.websocket.jsr356.ServerEndpointExporter;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.spec.ServletContextImpl;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.websocket.server.ServerContainer;

public class ServletHybridHandlerFactory
implements ActivityContextAware {
    private ActivityContext context;
    private ServletContainer servletContainer;
    private StaticResourceHandler staticResourceHandler;
    private List<HandlerWrapper> outerHandlerChainWrappers;

    @AvoidAdvice
    public void setActivityContext(ActivityContext context) {
        this.context = context;
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public void setServletContainer(ServletContainer servletContainer) {
        if (servletContainer == null) {
            throw new IllegalArgumentException("servletContainer must not be null");
        }
        this.servletContainer = servletContainer;
    }

    public StaticResourceHandler getStaticResourceHandler() {
        return this.staticResourceHandler;
    }

    public void setStaticResourceHandler(StaticResourceHandler staticResourceHandler) {
        if (staticResourceHandler == null) {
            throw new IllegalArgumentException("staticResourceHandler must not be null");
        }
        this.staticResourceHandler = staticResourceHandler;
    }

    public void setOuterHandlerChainWrappers(HandlerWrapper[] handlerWrappers) {
        if (handlerWrappers == null || handlerWrappers.length == 0) {
            throw new IllegalArgumentException("handlerWrappers must not be null or empty");
        }
        this.outerHandlerChainWrappers = Arrays.asList(handlerWrappers);
    }

    public HttpHandler createHandler() throws Exception {
        Object rootHandler;
        if (this.servletContainer != null) {
            PathHandler pathHandler = new PathHandler();
            for (String deploymentName : this.servletContainer.listDeployments()) {
                ServerContainer serverContainer;
                DeploymentManager manager = this.servletContainer.getDeployment(deploymentName);
                manager.deploy();
                ServletContextImpl servletContext = manager.getDeployment().getServletContext();
                Object attr = servletContext.getAttribute(TowServletContext.DERIVED_WEB_SERVICE_ATTR);
                servletContext.removeAttribute(TowServletContext.DERIVED_WEB_SERVICE_ATTR);
                if ("true".equals(attr)) {
                    CoreService rootService = this.context.getRootService();
                    DefaultWebService webService = DefaultWebService.create((ServletContext)servletContext, (CoreService)rootService);
                    servletContext.setAttribute(WebService.ROOT_WEB_SERVICE_ATTR_NAME, (Object)webService);
                }
                if ((serverContainer = (ServerContainer)servletContext.getAttribute(ServerContainer.class.getName())) != null) {
                    ServerEndpointExporter serverEndpointExporter = new ServerEndpointExporter(this.context);
                    serverEndpointExporter.initServletContext((ServletContext)servletContext);
                    serverEndpointExporter.registerEndpoints();
                }
                HttpHandler handler = manager.start();
                String contextPath = manager.getDeployment().getDeploymentInfo().getContextPath();
                pathHandler.addPrefixPath(contextPath, handler);
            }
            rootHandler = pathHandler;
        } else {
            rootHandler = ResponseCodeHandler.HANDLE_404;
        }
        if (this.staticResourceHandler != null && this.staticResourceHandler.hasPatterns()) {
            rootHandler = new ServletHybridHandler((HttpHandler)rootHandler, (HttpHandler)this.staticResourceHandler);
        }
        if (this.outerHandlerChainWrappers != null) {
            rootHandler = ServletHybridHandlerFactory.wrapHandlers((HttpHandler)rootHandler, this.outerHandlerChainWrappers);
        }
        return rootHandler;
    }

    private static HttpHandler wrapHandlers(HttpHandler wrapee, List<HandlerWrapper> wrappers) {
        HttpHandler current = wrapee;
        for (HandlerWrapper wrapper : wrappers) {
            current = wrapper.wrap(current);
        }
        return current;
    }
}

