/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.util.ResourceUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.undertow.server.servlet.TowTldScanner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;
import org.apache.jasper.servlet.JasperInitializer;
import org.apache.jasper.servlet.TldScanner;

public class TowJasperInitializer
extends JasperInitializer
implements ApplicationAdapterAware {
    private static final Logger logger = LoggerFactory.getLogger(TowJasperInitializer.class);
    private ApplicationAdapter applicationAdapter;
    private URL[] tldResources;

    public void setApplicationAdapter(ApplicationAdapter applicationAdapter) {
        this.applicationAdapter = applicationAdapter;
    }

    public void setTldResources(String[] resourcesToTldScan) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Specified TLD resources: " + Arrays.toString(resourcesToTldScan));
        }
        ArrayList<URL> tldResources = new ArrayList<URL>();
        if (resourcesToTldScan != null) {
            for (String resource : resourcesToTldScan) {
                if (resource == null) continue;
                tldResources.add(this.getURL(resource));
            }
        }
        this.tldResources = !tldResources.isEmpty() ? tldResources.toArray(new URL[0]) : null;
    }

    protected TldScanner newTldScanner(ServletContext context, boolean namespaceAware, boolean validate, boolean blockExternal) {
        TowTldScanner tldScanner = new TowTldScanner(context, namespaceAware, validate, blockExternal);
        tldScanner.setClassLoader(this.applicationAdapter.getClassLoader());
        tldScanner.setTldResources(this.tldResources);
        return tldScanner;
    }

    private URL getURL(String resourceLocation) throws FileNotFoundException {
        try {
            if (resourceLocation.startsWith("classpath:")) {
                return ResourceUtils.getURL((String)resourceLocation, (ClassLoader)this.applicationAdapter.getClassLoader());
            }
            File file = this.applicationAdapter.toRealPathAsFile(resourceLocation);
            return file.toURI().toURL();
        }
        catch (IOException ex) {
            throw new FileNotFoundException("In TLD scanning, the supplied resource '" + resourceLocation + "' does not exist");
        }
    }
}

