/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.undertow.server.servlet.TowFilter;
import com.aspectran.undertow.server.servlet.TowFilterServletMapping;
import com.aspectran.undertow.server.servlet.TowFilterUrlMapping;
import com.aspectran.undertow.server.servlet.TowListener;
import com.aspectran.undertow.server.servlet.TowServlet;
import com.aspectran.undertow.server.servlet.TowWebSocketInitializer;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.websocket.CloseReason;

public class TowServletContext
extends DeploymentInfo
implements ApplicationAdapterAware {
    public static final String DERIVED_WEB_SERVICE_ATTR = TowServletContext.class.getName() + ".DERIVED_WEB_SERVICE";
    private static final String WEBSOCKET_CURRENT_CONNECTIONS_ATTR = "io.undertow.websocket.current-connections";
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    private ApplicationAdapter applicationAdapter;
    private SessionManager sessionManager;

    public void setApplicationAdapter(ApplicationAdapter applicationAdapter) {
        this.applicationAdapter = applicationAdapter;
        this.setClassLoader(applicationAdapter.getClassLoader());
    }

    public void setScratchDir(String scratchDir) throws IOException {
        File dir = this.applicationAdapter.toRealPathAsFile(scratchDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.setTempDir(this.applicationAdapter.toRealPathAsFile(scratchDir));
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.setSessionManagerFactory(deployment -> sessionManager);
    }

    public void setInitParams(Map<String, String> initParams) {
        if (initParams != null) {
            for (Map.Entry<String, String> entry : initParams.entrySet()) {
                this.addInitParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setListeners(TowListener[] towListeners) {
        if (towListeners != null) {
            for (TowListener towListener : towListeners) {
                this.addListener(towListener);
            }
        }
    }

    public void setServlets(TowServlet[] towServlets) {
        if (towServlets != null) {
            for (TowServlet towServlet : towServlets) {
                this.addServlet(towServlet);
            }
        }
    }

    public void setFilters(TowFilter[] towFilters) {
        if (towFilters != null) {
            for (TowFilter towFilter : towFilters) {
                this.addFilter(towFilter);
            }
        }
    }

    public void setFilterUrlMappings(TowFilterUrlMapping[] towFilterUrlMappings) {
        if (towFilterUrlMappings != null) {
            for (TowFilterUrlMapping filterUrlMapping : towFilterUrlMappings) {
                this.addFilterUrlMapping(filterUrlMapping.getFilterName(), filterUrlMapping.getMapping(), filterUrlMapping.getDispatcher());
            }
        }
    }

    public void setFilterServletMappings(TowFilterServletMapping[] towFilterServletMappings) {
        if (towFilterServletMappings != null) {
            for (TowFilterServletMapping filterServletMapping : towFilterServletMappings) {
                this.addFilterServletNameMapping(filterServletMapping.getFilterName(), filterServletMapping.getMapping(), filterServletMapping.getDispatcher());
            }
        }
    }

    public void setServletContainerInitializers(ServletContainerInitializer[] servletContainerInitializers) {
        for (ServletContainerInitializer initializer : servletContainerInitializers) {
            Class<?> servletContainerInitializerClass = initializer.getClass();
            ImmediateInstanceFactory instanceFactory = new ImmediateInstanceFactory((Object)initializer);
            ServletContainerInitializerInfo sciInfo = new ServletContainerInitializerInfo(servletContainerInitializerClass, (InstanceFactory)instanceFactory, NO_CLASSES);
            this.addServletContainerInitializer(sciInfo);
        }
    }

    public void setWelcomePages(String[] welcomePages) {
        if (welcomePages != null) {
            this.addWelcomePages(welcomePages);
        }
    }

    public void setErrorPages(ErrorPage[] errorPages) {
        if (errorPages != null) {
            this.addErrorPages(errorPages);
        }
    }

    public void setInnerHandlerChainWrappers(HandlerWrapper[] wrappers) {
        if (wrappers != null) {
            for (HandlerWrapper wrapper : wrappers) {
                this.addInnerHandlerChainWrapper(wrapper);
            }
        }
    }

    public void setOuterHandlerChainWrappers(HandlerWrapper[] wrappers) {
        if (wrappers != null) {
            for (HandlerWrapper wrapper : wrappers) {
                this.addOuterHandlerChainWrapper(wrapper);
            }
        }
    }

    public void setWebSocketInitializer(TowWebSocketInitializer webSocketInitializer) {
        webSocketInitializer.initialize(this);
    }

    public void setDerived(boolean derived) {
        if (derived) {
            this.addServletContextAttribute(DERIVED_WEB_SERVICE_ATTR, "true");
        } else {
            this.getServletContextAttributes().remove(DERIVED_WEB_SERVICE_ATTR);
        }
    }

    public static class WebSocketConnectionsUnboundListener
    implements SessionListener {
        public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
            if (oldValue != null && oldValue != newValue) {
                this.closeWebSockets(name, oldValue);
            }
        }

        public void attributeRemoved(Session session, String name, Object oldValue) {
            this.closeWebSockets(name, oldValue);
        }

        private void closeWebSockets(String name, Object value) {
            if (TowServletContext.WEBSOCKET_CURRENT_CONNECTIONS_ATTR.equals(name)) {
                List connections = (List)value;
                for (WebSocketChannel c : new ArrayList(connections)) {
                    WebSockets.sendClose((int)CloseReason.CloseCodes.VIOLATED_POLICY.getCode(), (String)"", (WebSocketChannel)c, null);
                }
            }
        }
    }
}

