/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.undertow.server.servlet.TowServletContext;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;

public class TowWebSocketInitializer {
    private boolean directBuffers = false;
    private int bufferSize = 1024;
    private int maximumPoolSize = -1;
    private int threadLocalCacheSize = 12;

    public void setDirectBuffers(boolean directBuffers) {
        this.directBuffers = directBuffers;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setThreadLocalCacheSize(int threadLocalCacheSize) {
        this.threadLocalCacheSize = threadLocalCacheSize;
    }

    public void initialize(DeploymentInfo deploymentInfo) {
        if (!deploymentInfo.getServletContextAttributes().containsKey("io.undertow.websockets.jsr.WebSocketDeploymentInfo")) {
            deploymentInfo.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)new WebSocketDeploymentInfo().setBuffers((ByteBufferPool)new DefaultByteBufferPool(this.directBuffers, this.bufferSize, this.maximumPoolSize, this.threadLocalCacheSize)));
            deploymentInfo.addSessionListener((SessionListener)new TowServletContext.WebSocketConnectionsUnboundListener());
        }
    }
}

