/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.session;

import com.aspectran.core.component.session.Session;
import com.aspectran.undertow.server.session.TowSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.util.AttachmentKey;
import java.util.Set;

final class TowSessionBridge
implements io.undertow.server.session.Session {
    private final AttachmentKey<Boolean> FIRST_REQUEST_ACCESSED = AttachmentKey.create(Boolean.class);
    private final Session session;
    private final TowSessionManager sessionManager;

    TowSessionBridge(Session session, TowSessionManager sessionManager) {
        this.session = session;
        this.sessionManager = sessionManager;
    }

    public String getId() {
        return this.session.getId();
    }

    void requestStarted(HttpServerExchange serverExchange) {
        Boolean existing = (Boolean)serverExchange.getAttachment(this.FIRST_REQUEST_ACCESSED);
        if (existing == null) {
            serverExchange.putAttachment(this.FIRST_REQUEST_ACCESSED, (Object)true);
            this.session.access();
        }
    }

    public void requestDone(HttpServerExchange serverExchange) {
        this.session.complete();
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this.session.getAttributeNames();
    }

    public Object setAttribute(String name, Object value) {
        return this.session.setAttribute(name, value);
    }

    public Object removeAttribute(String name) {
        return this.session.removeAttribute(name);
    }

    public void invalidate(HttpServerExchange exchange) {
        this.session.invalidate();
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        String oldId = this.session.getId();
        String newId = this.sessionManager.getSessionHandler().createSessionId((long)this.hashCode());
        String sessionId = this.sessionManager.getSessionHandler().renewSessionId(oldId, newId);
        if (sessionId != null) {
            config.setSessionId(exchange, sessionId);
        }
        return sessionId;
    }
}

