/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.session;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.component.session.DefaultSession;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionStoreFactory;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.undertow.server.session.TowSessionBridge;
import com.aspectran.undertow.server.session.TowSessionListenerBridge;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.server.session.SessionManagerStatistics;
import io.undertow.util.AttachmentKey;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TowSessionManager
implements SessionManager,
ApplicationAdapterAware,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(TowSessionManager.class);
    private final AttachmentKey<TowSessionBridge> NEW_SESSION = AttachmentKey.create(TowSessionBridge.class);
    private final Map<SessionListener, TowSessionListenerBridge> sessionListenerMappings = new ConcurrentHashMap<SessionListener, TowSessionListenerBridge>();
    private final DefaultSessionManager sessionManager = new DefaultSessionManager();
    private volatile long startTime;

    public void setApplicationAdapter(ApplicationAdapter applicationAdapter) {
        this.sessionManager.setApplicationAdapter(applicationAdapter);
    }

    public void setSessionManagerConfig(SessionManagerConfig sessionManagerConfig) {
        this.sessionManager.setSessionManagerConfig(sessionManagerConfig);
    }

    public void setSessionManagerConfigWithApon(String apon) {
        SessionManagerConfig sessionManagerConfig = new SessionManagerConfig();
        try {
            sessionManagerConfig.readFrom(apon);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setSessionManagerConfig(sessionManagerConfig);
    }

    public void setSessionStoreFactory(SessionStoreFactory sessionStoreFactory) {
        this.sessionManager.setSessionStoreFactory(sessionStoreFactory);
    }

    public SessionHandler getSessionHandler() {
        return this.sessionManager.getSessionHandler();
    }

    public String getDeploymentName() {
        return this.sessionManager.getWorkerName();
    }

    public void start() {
        try {
            this.sessionManager.initialize();
            this.startTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing TowSessionManager", e);
        }
    }

    public void stop() {
        try {
            this.sessionManager.destroy();
        }
        catch (Exception e) {
            throw new RuntimeException("Error destroying TowSessionManager", e);
        }
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public Session createSession(HttpServerExchange serverExchange, SessionConfig sessionConfig) {
        String sessionId;
        try {
            sessionId = sessionConfig.findSessionId(serverExchange);
        }
        catch (Exception e) {
            logger.error("Unable to create new session due to failure to find session ID", (Throwable)e);
            return null;
        }
        if (sessionId == null) {
            sessionId = this.sessionManager.createSessionId((long)this.hashCode());
        }
        DefaultSession session = this.sessionManager.createSession(sessionId);
        TowSessionBridge sessionBridge = this.newTowSessionBridge((com.aspectran.core.component.session.Session)session);
        sessionConfig.setSessionId(serverExchange, session.getId());
        serverExchange.putAttachment(this.NEW_SESSION, (Object)sessionBridge);
        return sessionBridge;
    }

    public Session getSession(HttpServerExchange serverExchange, SessionConfig sessionConfig) {
        String sessionId;
        TowSessionBridge newSession;
        if (serverExchange != null && (newSession = (TowSessionBridge)serverExchange.getAttachment(this.NEW_SESSION)) != null) {
            return newSession;
        }
        try {
            sessionId = sessionConfig.findSessionId(serverExchange);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve session due to failure to find session ID", (Throwable)e);
            return null;
        }
        TowSessionBridge sessionWrapper = (TowSessionBridge)this.getSession(sessionId);
        if (sessionWrapper != null && serverExchange != null) {
            sessionWrapper.requestStarted(serverExchange);
        }
        return sessionWrapper;
    }

    public Session getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        DefaultSession session = this.sessionManager.getSession(sessionId);
        if (session != null) {
            return this.newTowSessionBridge((com.aspectran.core.component.session.Session)session);
        }
        return null;
    }

    public void registerSessionListener(SessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        TowSessionListenerBridge sessionListenerBridge = new TowSessionListenerBridge(listener, this);
        this.sessionListenerMappings.put(listener, sessionListenerBridge);
        this.sessionManager.addSessionListener((com.aspectran.core.component.session.SessionListener)sessionListenerBridge);
    }

    public void removeSessionListener(SessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        TowSessionListenerBridge sessionListenerBridge = this.sessionListenerMappings.remove(listener);
        if (sessionListenerBridge != null) {
            this.sessionManager.removeSessionListener((com.aspectran.core.component.session.SessionListener)sessionListenerBridge);
        }
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.sessionManager.setDefaultMaxIdleSecs(timeout);
    }

    public Set<String> getTransientSessions() {
        return this.getAllSessions();
    }

    public Set<String> getActiveSessions() {
        return this.getAllSessions();
    }

    public Set<String> getAllSessions() {
        return new HashSet<String>(this.sessionManager.getSessionCache().getAllSessions());
    }

    public SessionManagerStatistics getStatistics() {
        return new SessionManagerStatistics(){

            public long getCreatedSessionCount() {
                return TowSessionManager.this.sessionManager.getSessionCache().getCreatedSessionCount();
            }

            public long getMaxActiveSessions() {
                return TowSessionManager.this.sessionManager.getSessionCache().getMaxSessions();
            }

            public long getHighestSessionCount() {
                return TowSessionManager.this.sessionManager.getSessionCache().getHighestSessionCount();
            }

            public long getActiveSessionCount() {
                return TowSessionManager.this.sessionManager.getSessionCache().getActiveSessionCount();
            }

            public long getExpiredSessionCount() {
                return TowSessionManager.this.sessionManager.getSessionCache().getExpiredSessionCount();
            }

            public long getRejectedSessions() {
                return TowSessionManager.this.sessionManager.getSessionCache().getRejectedSessionCount();
            }

            public long getMaxSessionAliveTime() {
                return TowSessionManager.this.sessionManager.getSessionHandler().getSessionTimeMax();
            }

            public long getAverageSessionAliveTime() {
                return TowSessionManager.this.sessionManager.getSessionHandler().getSessionTimeMean();
            }

            public long getStartTime() {
                return TowSessionManager.this.startTime;
            }
        };
    }

    TowSessionBridge newTowSessionBridge(com.aspectran.core.component.session.Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        return new TowSessionBridge(session, this);
    }
}

