/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.service;

import com.aspectran.core.activity.ActivityException;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.RequestMethodNotAllowedException;
import com.aspectran.core.activity.request.SizeLimitExceededException;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ExposalsConfig;
import com.aspectran.core.context.config.WebConfig;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.undertow.activity.TowActivity;
import com.aspectran.undertow.service.AbstractTowService;
import com.aspectran.web.support.http.HttpStatus;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.net.URLDecoder;

public class DefaultTowService
extends AbstractTowService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTowService.class);
    private volatile long pauseTimeout = -2L;

    public DefaultTowService() {
    }

    public DefaultTowService(CoreService rootService) {
        super(rootService);
    }

    @Override
    public boolean execute(HttpServerExchange exchange) throws IOException {
        String requestPath = exchange.getRequestPath();
        if (this.getUriDecoding() != null) {
            requestPath = URLDecoder.decode(requestPath, this.getUriDecoding());
        }
        if (!this.isExposable(requestPath)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getRequestInfo(exchange));
        }
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.getServiceName() + " has been paused, so did not respond to the request URI \"" + requestPath + "\"");
                }
                exchange.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE.value());
                return true;
            }
            if (this.pauseTimeout == -2L) {
                logger.error(this.getServiceName() + " is not yet started");
                exchange.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE.value());
                return true;
            }
            this.pauseTimeout = 0L;
        }
        try {
            TowActivity activity = new TowActivity(this, exchange);
            activity.prepare(requestPath, exchange.getRequestMethod().toString());
            activity.perform();
        }
        catch (TransletNotFoundException e) {
            String transletName = e.getTransletName();
            if (StringUtils.startsWith((String)transletName, (char)'/') && !StringUtils.endsWith((String)transletName, (char)'/')) {
                String transletNameWithSlash = transletName + '/';
                MethodType requestMethod = e.getRequestMethod(MethodType.GET);
                if (this.getActivityContext().getTransletRuleRegistry().contains(transletNameWithSlash, requestMethod)) {
                    exchange.setStatusCode(HttpStatus.MOVED_PERMANENTLY.value());
                    exchange.getResponseHeaders().put(Headers.LOCATION, transletNameWithSlash);
                    exchange.getResponseHeaders().put(Headers.CONNECTION, "close");
                    if (logger.isDebugEnabled()) {
                        logger.debug("Redirect URL with Trailing Slash: " + e.getTransletName());
                    }
                    return true;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("No translet mapped for request URI [" + requestPath + "]");
            }
            return false;
        }
        catch (ActivityTerminatedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Activity terminated: " + e.getMessage());
            }
        }
        catch (ActivityException e) {
            if (e.getCause() != null) {
                logger.error(e.getCause().getMessage(), e.getCause());
            } else {
                logger.error((Throwable)e);
            }
            if (e.getCause() instanceof RequestMethodNotAllowedException) {
                exchange.setStatusCode(HttpStatus.METHOD_NOT_ALLOWED.value());
            } else if (e.getCause() instanceof SizeLimitExceededException) {
                exchange.setStatusCode(HttpStatus.PAYLOAD_TOO_LARGE.value());
            } else {
                exchange.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
            }
        }
        catch (Exception e) {
            logger.error("An error occurred while processing request: " + requestPath, (Throwable)e);
            exchange.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        return true;
    }

    private String getRequestInfo(HttpServerExchange exchange) {
        StringBuilder sb = new StringBuilder();
        sb.append(exchange.getRequestMethod()).append(" ");
        sb.append(exchange.getRequestURI()).append(" ");
        sb.append(exchange.getProtocol()).append(" ");
        String remoteAddr = exchange.getRequestHeaders().getFirst("X-FORWARDED-FOR");
        if (!StringUtils.isEmpty((String)remoteAddr)) {
            sb.append(remoteAddr);
        } else {
            sb.append(exchange.getSourceAddress());
        }
        return sb.toString();
    }

    public static DefaultTowService create(CoreService rootService) {
        WebConfig webConfig;
        DefaultTowService service = new DefaultTowService(rootService);
        AspectranConfig aspectranConfig = rootService.getAspectranConfig();
        if (aspectranConfig != null && (webConfig = aspectranConfig.getWebConfig()) != null) {
            DefaultTowService.applyWebConfig(service, webConfig);
        }
        DefaultTowService.setServiceStateListener(service);
        if (service.isLateStart()) {
            try {
                service.getServiceController().start();
            }
            catch (Exception e) {
                throw new AspectranServiceException("Failed to start DefaultTowService");
            }
        }
        return service;
    }

    public static DefaultTowService create(AspectranConfig aspectranConfig) {
        DefaultTowService service = new DefaultTowService();
        service.prepare(aspectranConfig);
        WebConfig webConfig = aspectranConfig.getWebConfig();
        if (webConfig != null) {
            DefaultTowService.applyWebConfig(service, webConfig);
        }
        DefaultTowService.setServiceStateListener(service);
        return service;
    }

    private static void applyWebConfig(DefaultTowService service, WebConfig webConfig) {
        service.setUriDecoding(webConfig.getUriDecoding());
        ExposalsConfig exposalsConfig = webConfig.getExposalsConfig();
        if (exposalsConfig != null) {
            String[] includePatterns = exposalsConfig.getIncludePatterns();
            String[] excludePatterns = exposalsConfig.getExcludePatterns();
            service.setExposals(includePatterns, excludePatterns);
        }
    }

    private static void setServiceStateListener(final DefaultTowService service) {
        service.setServiceStateListener(new ServiceStateListener(){

            public void started() {
                service.pauseTimeout = 0L;
            }

            public void restarted() {
                this.started();
            }

            public void paused(long millis) {
                if (millis > 0L) {
                    service.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    logger.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            public void paused() {
                service.pauseTimeout = -1L;
            }

            public void resumed() {
                this.started();
            }

            public void stopped() {
                this.paused();
            }
        });
    }
}

