/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.shell.command;

import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;
import com.aspectran.undertow.server.TowServer;
import io.undertow.Version;
import java.net.BindException;

public class UndertowCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "undertow";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public UndertowCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder((String)"server").valueName("name").withEqualSign().desc("ID of bean that defined Undertow server").build());
        this.addOption(Option.builder((String)"h").longName("help").desc("Display help for this command").build());
        Arguments arguments = this.touchArguments();
        arguments.setTitle("Commands:");
        arguments.put((Object)"start", (Object)"Start Undertow server");
        arguments.put((Object)"stop", (Object)"Stop Undertow server");
        arguments.put((Object)"restart", (Object)"Restart Undertow server");
        arguments.put((Object)"status", (Object)"Display a brief status report");
        arguments.setRequired(true);
    }

    public void execute(ParsedOptions options, Console console) throws Exception {
        TowServer towServer;
        boolean justCreated;
        if (!options.hasOptions() && !options.hasArgs()) {
            this.printQuickHelp(console);
            return;
        }
        if (options.hasOption("help")) {
            this.printHelp(console);
            return;
        }
        String command = null;
        if (options.hasArgs()) {
            command = options.getFirstArg();
        }
        ShellService service = this.getService();
        String serverName = options.getValue("server", "tow.server");
        BeanRegistry beanRegistry = service.getActivityContext().getBeanRegistry();
        boolean bl = justCreated = !beanRegistry.hasSingleton(TowServer.class, serverName);
        if (justCreated && ("stop".equals(command) || "restart".equals(command))) {
            console.writeError("Undertow server is not running");
            return;
        }
        try {
            towServer = (TowServer)((Object)beanRegistry.getBean(TowServer.class, serverName));
        }
        catch (Exception e) {
            console.writeError("Undertow server is not available. Cause: " + e.getMessage());
            return;
        }
        if (command != null) {
            switch (command) {
                case "start": {
                    if (!justCreated && towServer.isRunning()) {
                        console.writeError("Undertow server is already running");
                        return;
                    }
                    try {
                        if (!towServer.isAutoStart()) {
                            towServer.start();
                        }
                        this.printStatus(towServer, console);
                    }
                    catch (BindException e) {
                        console.writeError("Undertow Server Error - Port already in use");
                    }
                    break;
                }
                case "stop": {
                    if (!towServer.isRunning()) {
                        console.writeError("Undertow server is not running");
                        return;
                    }
                    try {
                        towServer.stop();
                        this.printStatus(towServer, console);
                        beanRegistry.destroySingleton((Object)towServer);
                    }
                    catch (Exception e) {
                        console.writeError("Undertow Server Error - " + e.getMessage());
                    }
                    break;
                }
                case "restart": {
                    try {
                        if (towServer.isRunning()) {
                            towServer.stop();
                            beanRegistry.destroySingleton((Object)towServer);
                            towServer = (TowServer)((Object)beanRegistry.getBean(TowServer.class, serverName));
                        }
                        if (!towServer.isAutoStart()) {
                            towServer.start();
                        }
                        this.printStatus(towServer, console);
                    }
                    catch (BindException e) {
                        console.writeError("Undertow Server Error - Port already in use");
                    }
                    break;
                }
                case "status": {
                    this.printStatus(towServer, console);
                    break;
                }
                default: {
                    console.writeError("Unknown command '" + String.join((CharSequence)" ", options.getArgs()) + "'");
                    this.printQuickHelp(console);
                    break;
                }
            }
        } else {
            this.printQuickHelp(console);
        }
    }

    private void printStatus(TowServer towServer, Console console) {
        console.writeLine("----------------------------------------------------------------------------");
        console.setStyle(new String[]{"YELLOW"});
        console.write(towServer.getState());
        console.styleOff();
        console.writeLine(" - Undertow " + Version.getVersionString());
        console.writeLine("----------------------------------------------------------------------------");
    }

    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        public String getNamespace() {
            return UndertowCommand.NAMESPACE;
        }

        public String getName() {
            return UndertowCommand.COMMAND_NAME;
        }

        public String getDescription() {
            return "Use the command 'undertow' to control the Undertow server";
        }

        public String getUsage() {
            return null;
        }
    }
}

