/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.http;

import com.aspectran.undertow.server.resource.StaticResourceHandler;
import com.aspectran.undertow.service.TowService;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.ResourceSupplier;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;

public class HttpHybridHandler
extends ResourceHandler {
    private volatile StaticResourceHandler staticResourceHandler;
    private volatile SessionManager sessionManager;
    private volatile SessionConfig sessionConfig;
    private volatile TowService towService;

    public HttpHybridHandler(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public HttpHybridHandler(ResourceManager resourceManager, HttpHandler next) {
        super(resourceManager, next);
    }

    public HttpHybridHandler(ResourceSupplier resourceSupplier) {
        super(resourceSupplier);
    }

    public HttpHybridHandler(ResourceSupplier resourceSupplier, HttpHandler next) {
        super(resourceSupplier, next);
    }

    public StaticResourceHandler getStaticResourceHandler() {
        return this.staticResourceHandler;
    }

    public void setStaticResourceHandler(StaticResourceHandler staticResourceHandler) {
        this.staticResourceHandler = staticResourceHandler != null && staticResourceHandler.hasPatterns() ? staticResourceHandler : null;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public void setTowService(TowService towService) {
        this.towService = towService;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
        } else {
            boolean processed;
            if (this.staticResourceHandler != null) {
                this.staticResourceHandler.handleRequest(exchange);
                if (exchange.isDispatched() || exchange.isComplete()) {
                    return;
                }
            }
            if (this.sessionManager != null) {
                exchange.putAttachment(SessionManager.ATTACHMENT_KEY, (Object)this.sessionManager);
                exchange.putAttachment(SessionConfig.ATTACHMENT_KEY, (Object)this.sessionConfig);
                UpdateLastAccessTimeListener listener = new UpdateLastAccessTimeListener(this.sessionManager, this.sessionConfig);
                exchange.addExchangeCompleteListener((ExchangeCompletionListener)listener);
            }
            if (!(processed = this.towService.service(exchange))) {
                super.handleRequest(exchange);
            }
        }
    }

    private static class UpdateLastAccessTimeListener
    implements ExchangeCompletionListener {
        private final SessionManager sessionManager;
        private final SessionConfig sessionConfig;

        private UpdateLastAccessTimeListener(SessionManager sessionManager, SessionConfig sessionConfig) {
            this.sessionManager = sessionManager;
            this.sessionConfig = sessionConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener next) {
            try {
                Session session = this.sessionManager.getSession(exchange, this.sessionConfig);
                if (session != null) {
                    session.requestDone(exchange);
                }
            }
            finally {
                next.proceed();
            }
        }
    }
}

