/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.resource;

import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.core.util.wildcard.PluralWildcardPattern;
import com.aspectran.core.util.wildcard.WildcardPattern;
import com.aspectran.undertow.server.resource.ResourcePathPatterns;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.ResourceSupplier;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class StaticResourceHandler
extends ResourceHandler {
    private static final Logger logger = LoggerFactory.getLogger(StaticResourceHandler.class);
    private volatile PluralWildcardPattern resourcePathPatterns;

    public StaticResourceHandler(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public StaticResourceHandler(ResourceManager resourceManager, HttpHandler next) {
        super(resourceManager, next);
    }

    public StaticResourceHandler(ResourceSupplier resourceSupplier) {
        super(resourceSupplier);
    }

    public StaticResourceHandler(ResourceSupplier resourceSupplier, HttpHandler next) {
        super(resourceSupplier, next);
    }

    public void setResourcePathPatterns(ResourcePathPatterns resourcePathPatterns) {
        String[] includePatterns = resourcePathPatterns.getIncludePatterns();
        String[] excludePatterns = resourcePathPatterns.getExcludePatterns();
        this.resourcePathPatterns = new PluralWildcardPattern(includePatterns, excludePatterns, '/');
    }

    public void autoDetect() throws IOException {
        if (this.getResourceManager() instanceof PathResourceManager) {
            Path base = ((PathResourceManager)this.getResourceManager()).getBasePath();
            HashSet<CallSite> dirs = new HashSet<CallSite>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(base);){
                for (Path path : stream) {
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    dirs.add((CallSite)((Object)("/" + path.getFileName().toString() + "/")));
                }
            }
            LinkedHashSet<Iterator<Path>> patterns = new LinkedHashSet<Iterator<Path>>();
            if (this.resourcePathPatterns != null && this.resourcePathPatterns.hasIncludePatterns()) {
                for (Iterator<Path> iterator : this.resourcePathPatterns.getIncludePatterns()) {
                    boolean exists = false;
                    for (String string : dirs) {
                        if (!iterator.toString().startsWith(string)) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    patterns.add(iterator);
                }
            }
            for (String string : dirs) {
                patterns.add((Iterator<Path>)WildcardPattern.compile((String)(string + "**"), (char)'/'));
            }
            if (patterns.isEmpty()) {
                this.resourcePathPatterns = null;
            } else {
                Object[] includePatterns = patterns.toArray(new WildcardPattern[0]);
                Object[] objectArray = this.resourcePathPatterns != null ? this.resourcePathPatterns.getExcludePatterns() : null;
                this.resourcePathPatterns = new PluralWildcardPattern((WildcardPattern[])includePatterns, (WildcardPattern[])objectArray);
                if (logger.isDebugEnabled()) {
                    logger.debug("StaticResourceHandler includePatterns=" + Arrays.toString(includePatterns));
                    if (objectArray != null) {
                        logger.debug("StaticResourceHandler excludePatterns=" + Arrays.toString(objectArray));
                    }
                }
            }
        }
    }

    public boolean hasPatterns() {
        return this.resourcePathPatterns != null;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String requestPath = exchange.getRequestPath();
        if (this.resourcePathPatterns != null && this.resourcePathPatterns.matches(requestPath)) {
            super.handleRequest(exchange);
        }
    }
}

