/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.util.ArrayList;
import java.util.List;

public class TowWebSocketInitializer {
    private static final String WEBSOCKET_CURRENT_CONNECTIONS_ATTR = "io.undertow.websocket.current-connections";
    private boolean directBuffers = false;
    private int bufferSize = 1024;
    private int maximumPoolSize = -1;
    private int threadLocalCacheSize = 12;

    public void setDirectBuffers(boolean directBuffers) {
        this.directBuffers = directBuffers;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setThreadLocalCacheSize(int threadLocalCacheSize) {
        this.threadLocalCacheSize = threadLocalCacheSize;
    }

    public void initialize(DeploymentInfo deploymentInfo) {
        if (!deploymentInfo.getServletContextAttributes().containsKey("io.undertow.websockets.jsr.WebSocketDeploymentInfo")) {
            deploymentInfo.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)new WebSocketDeploymentInfo().setBuffers((ByteBufferPool)new DefaultByteBufferPool(this.directBuffers, this.bufferSize, this.maximumPoolSize, this.threadLocalCacheSize)));
            deploymentInfo.addSessionListener((SessionListener)new WebSocketGracefulUndeployListener());
        }
    }

    public static class WebSocketGracefulUndeployListener
    implements SessionListener {
        public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
            if (oldValue != null && oldValue != newValue) {
                this.closeWebSockets(name, oldValue);
            }
        }

        public void attributeRemoved(Session session, String name, Object oldValue) {
            this.closeWebSockets(name, oldValue);
        }

        private void closeWebSockets(String name, Object value) {
            if (TowWebSocketInitializer.WEBSOCKET_CURRENT_CONNECTIONS_ATTR.equals(name)) {
                List connections = (List)value;
                CloseMessage closeMessage = new CloseMessage(1008, null);
                for (WebSocketChannel webSocketChannel : new ArrayList(connections)) {
                    WebSockets.sendClose((CloseMessage)closeMessage, (WebSocketChannel)webSocketChannel, null);
                }
            }
        }
    }
}

