/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.session;

import com.aspectran.core.component.session.Session;
import com.aspectran.undertow.server.session.TowSessionBridge;
import com.aspectran.undertow.server.session.TowSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.handlers.ServletRequestContext;

final class TowSessionListenerBridge
implements com.aspectran.core.component.session.SessionListener {
    private final SessionListener listener;
    private final TowSessionManager towSessionManager;

    TowSessionListenerBridge(SessionListener listener, TowSessionManager towSessionManager) {
        this.listener = listener;
        this.towSessionManager = towSessionManager;
    }

    public void sessionCreated(Session session) {
        this.listener.sessionCreated((io.undertow.server.session.Session)this.wrapSession(session), TowSessionListenerBridge.getCurrentExchange());
    }

    public void sessionDestroyed(Session session) {
        SessionListener.SessionDestroyedReason reason = null;
        if (session != null && session.getDestroyedReason() != null) {
            switch (session.getDestroyedReason()) {
                case INVALIDATED: {
                    reason = SessionListener.SessionDestroyedReason.INVALIDATED;
                    break;
                }
                case TIMEOUT: {
                    reason = SessionListener.SessionDestroyedReason.TIMEOUT;
                    break;
                }
                case UNDEPLOY: {
                    reason = SessionListener.SessionDestroyedReason.UNDEPLOY;
                }
            }
        }
        this.listener.sessionDestroyed((io.undertow.server.session.Session)this.wrapSession(session), TowSessionListenerBridge.getCurrentExchange(), reason);
    }

    public void attributeAdded(Session session, String name, Object value) {
        this.listener.attributeAdded((io.undertow.server.session.Session)this.wrapSession(session), name, value);
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
        this.listener.attributeUpdated((io.undertow.server.session.Session)this.wrapSession(session), name, newValue, oldValue);
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
        this.listener.attributeRemoved((io.undertow.server.session.Session)this.wrapSession(session), name, oldValue);
    }

    public void sessionIdChanged(Session session, String oldSessionId) {
        this.listener.sessionIdChanged((io.undertow.server.session.Session)this.wrapSession(session), oldSessionId);
    }

    private TowSessionBridge wrapSession(Session session) {
        return this.towSessionManager.createTowSessionBridge(session);
    }

    static HttpServerExchange getCurrentExchange() {
        ServletRequestContext current = ServletRequestContext.current();
        return current != null ? current.getExchange() : null;
    }
}

