/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.service;

import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.request.RequestMethodNotAllowedException;
import com.aspectran.core.activity.request.SizeLimitExceededException;
import com.aspectran.core.component.session.MaxSessionsExceededException;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ExposalsConfig;
import com.aspectran.core.context.config.WebConfig;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.core.util.ExceptionUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.undertow.activity.TowActivity;
import com.aspectran.undertow.service.AbstractTowService;
import com.aspectran.web.support.http.HttpStatus;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.net.URLDecoder;

public class DefaultTowService
extends AbstractTowService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTowService.class);
    private boolean trailingSlashRedirect;
    private volatile long pauseTimeout = -2L;

    public DefaultTowService() {
    }

    public DefaultTowService(CoreService rootService) {
        super(rootService);
    }

    public void setTrailingSlashRedirect(boolean trailingSlashRedirect) {
        this.trailingSlashRedirect = trailingSlashRedirect;
    }

    @Override
    public boolean service(HttpServerExchange exchange) throws IOException {
        TransletRule transletRule;
        MethodType requestMethod;
        String requestPath = exchange.getRequestPath();
        if (this.getUriDecoding() != null) {
            requestPath = URLDecoder.decode(requestPath, this.getUriDecoding());
        }
        if (!this.isExposable(requestPath)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getRequestInfo(exchange));
        }
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.getServiceName() + " has been paused, so did not respond to request " + requestPath);
                }
                exchange.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE.value());
                return true;
            }
            if (this.pauseTimeout == -2L) {
                logger.error(this.getServiceName() + " is not yet started");
                exchange.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE.value());
                return true;
            }
            this.pauseTimeout = 0L;
        }
        if ((requestMethod = MethodType.resolve((String)exchange.getRequestMethod().toString())) == null) {
            requestMethod = MethodType.GET;
        }
        if ((transletRule = this.getActivityContext().getTransletRuleRegistry().getTransletRule(requestPath, requestMethod)) == null) {
            if (this.trailingSlashRedirect && requestMethod == MethodType.GET && StringUtils.startsWith((String)requestPath, (char)'/') && !StringUtils.endsWith((String)requestPath, (char)'/')) {
                String transletNameWithSlash = requestPath + "/";
                if (this.getActivityContext().getTransletRuleRegistry().contains(transletNameWithSlash, requestMethod)) {
                    exchange.setStatusCode(HttpStatus.MOVED_PERMANENTLY.value());
                    exchange.getResponseHeaders().put(Headers.LOCATION, transletNameWithSlash);
                    exchange.getResponseHeaders().put(Headers.CONNECTION, "close");
                    if (logger.isTraceEnabled()) {
                        logger.trace("Redirect URL with a Trailing Slash: " + requestPath);
                    }
                    return true;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("No translet mapped for " + requestMethod + " " + requestPath);
            }
            exchange.setStatusCode(HttpStatus.NOT_FOUND.value());
            return true;
        }
        this.perform(exchange, requestPath, requestMethod, transletRule);
        return true;
    }

    private void perform(HttpServerExchange exchange, String requestPath, MethodType requestMethod, TransletRule transletRule) {
        try {
            TowActivity activity = new TowActivity(this, exchange);
            activity.prepare(requestPath, requestMethod, transletRule);
            activity.perform();
        }
        catch (ActivityTerminatedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Activity terminated: " + e.getMessage());
            }
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
            if (cause == null) {
                cause = e;
            }
            logger.error("Error while processing " + requestMethod + " request " + requestPath + "; Cause: " + cause);
            if (cause instanceof RequestMethodNotAllowedException) {
                exchange.setStatusCode(HttpStatus.METHOD_NOT_ALLOWED.value());
            }
            if (cause instanceof SizeLimitExceededException) {
                exchange.setStatusCode(HttpStatus.PAYLOAD_TOO_LARGE.value());
            }
            if (cause instanceof MaxSessionsExceededException) {
                exchange.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE.value());
                exchange.setReasonPhrase("Max Sessions Exceeded");
            }
            exchange.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
    }

    private String getRequestInfo(HttpServerExchange exchange) {
        StringBuilder sb = new StringBuilder();
        sb.append(exchange.getRequestMethod()).append(" ");
        sb.append(exchange.getRequestURI()).append(" ");
        sb.append(exchange.getProtocol()).append(" ");
        String remoteAddr = exchange.getRequestHeaders().getFirst("X-Forwarded-For");
        if (!StringUtils.isEmpty((String)remoteAddr)) {
            sb.append(remoteAddr);
        } else {
            sb.append(exchange.getSourceAddress());
        }
        return sb.toString();
    }

    public static DefaultTowService create(CoreService rootService) {
        WebConfig webConfig;
        DefaultTowService service = new DefaultTowService(rootService);
        AspectranConfig aspectranConfig = rootService.getAspectranConfig();
        if (aspectranConfig != null && (webConfig = aspectranConfig.getWebConfig()) != null) {
            DefaultTowService.applyWebConfig(service, webConfig);
        }
        DefaultTowService.setServiceStateListener(service);
        if (service.isLateStart()) {
            try {
                service.getServiceController().start();
            }
            catch (Exception e) {
                throw new AspectranServiceException("Failed to start DefaultTowService");
            }
        }
        return service;
    }

    public static DefaultTowService create(AspectranConfig aspectranConfig) {
        DefaultTowService service = new DefaultTowService();
        service.prepare(aspectranConfig);
        WebConfig webConfig = aspectranConfig.getWebConfig();
        if (webConfig != null) {
            DefaultTowService.applyWebConfig(service, webConfig);
        }
        DefaultTowService.setServiceStateListener(service);
        return service;
    }

    private static void applyWebConfig(DefaultTowService service, WebConfig webConfig) {
        service.setUriDecoding(webConfig.getUriDecoding());
        service.setTrailingSlashRedirect(webConfig.isTrailingSlashRedirect());
        ExposalsConfig exposalsConfig = webConfig.getExposalsConfig();
        if (exposalsConfig != null) {
            String[] includePatterns = exposalsConfig.getIncludePatterns();
            String[] excludePatterns = exposalsConfig.getExcludePatterns();
            service.setExposals(includePatterns, excludePatterns);
        }
    }

    private static void setServiceStateListener(final DefaultTowService service) {
        service.setServiceStateListener(new ServiceStateListener(){

            public void started() {
                service.pauseTimeout = 0L;
            }

            public void restarted() {
                this.started();
            }

            public void paused(long millis) {
                if (millis > 0L) {
                    service.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    logger.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            public void paused() {
                service.pauseTimeout = -1L;
            }

            public void resumed() {
                this.started();
            }

            public void stopped() {
                this.paused();
            }
        });
    }
}

