/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.support;

import com.aspectran.core.activity.InstantActivitySupport;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionListener;
import com.aspectran.core.component.session.SessionListenerRegistration;
import com.aspectran.undertow.server.TowServer;
import com.aspectran.undertow.server.session.TowSessionManager;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.DeploymentManager;

public class SessionListenerRegistrationBean
extends InstantActivitySupport
implements SessionListenerRegistration,
InitializableBean {
    private final String towServerId;
    private final String deploymentName;
    private SessionHandler sessionHandler;

    public SessionListenerRegistrationBean(String towServerId, String deploymentName) {
        this.towServerId = towServerId;
        this.deploymentName = deploymentName;
    }

    public void register(SessionListener listener) {
        this.sessionHandler.addSessionListener(listener);
    }

    public void remove(SessionListener listener) {
        this.sessionHandler.removeSessionListener(listener);
    }

    private SessionHandler getSessionHandler() {
        TowServer towServer = (TowServer)((Object)this.getBeanRegistry().getBean(this.towServerId));
        if (towServer == null) {
            throw new IllegalArgumentException("No TowServer named '" + this.towServerId + "'");
        }
        DeploymentManager deploymentManager = towServer.getServletContainer().getDeployment(this.deploymentName);
        if (deploymentManager == null) {
            throw new IllegalArgumentException("TowServer named '" + this.towServerId + "' does not have a deployment called '" + this.deploymentName + "'");
        }
        SessionManager sessionManager = deploymentManager.getDeployment().getSessionManager();
        if (sessionManager instanceof TowSessionManager) {
            return ((TowSessionManager)sessionManager).getSessionHandler();
        }
        throw new IllegalStateException("TowServer does not have TowSessionManager configured");
    }

    public void initialize() throws Exception {
        this.sessionHandler = this.getSessionHandler();
    }
}

