/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.activity;

import com.aspectran.core.activity.ActivityPrepareException;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.support.i18n.locale.LocaleChangeInterceptor;
import com.aspectran.core.support.i18n.locale.LocaleResolver;
import com.aspectran.undertow.adapter.TowRequestAdapter;
import com.aspectran.undertow.adapter.TowResponseAdapter;
import com.aspectran.undertow.adapter.TowSessionAdapter;
import com.aspectran.undertow.service.TowService;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.web.activity.request.MultipartFormDataParser;
import com.aspectran.web.activity.request.MultipartRequestParseException;
import com.aspectran.web.activity.request.WebRequestBodyParser;
import com.aspectran.web.support.http.MediaType;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import java.io.UnsupportedEncodingException;

public class TowActivity
extends CoreActivity {
    private static final String MULTIPART_FORM_DATA_PARSER_SETTING_NAME = "multipartFormDataParser";
    private static final String MAX_REQUEST_SIZE_SETTING_NAME = "maxRequestSize";
    private final HttpServerExchange exchange;

    public TowActivity(@NonNull TowService service, HttpServerExchange exchange) {
        super(service.getActivityContext());
        this.exchange = exchange;
    }

    public void prepare(String transletName, MethodType requestMethod, TransletRule transletRule) throws ActivityPrepareException {
        MethodType hiddenRequestMethod;
        String method;
        if (requestMethod == MethodType.POST && (method = this.exchange.getRequestHeaders().getFirst("X-Method-Override")) != null && (hiddenRequestMethod = MethodType.resolve((String)method)) != null) {
            requestMethod = hiddenRequestMethod;
        }
        super.prepare(transletName, requestMethod, transletRule);
    }

    protected void adapt() throws AdapterException {
        try {
            String responseEncoding;
            if (this.getParentActivity() == null) {
                SessionManager sessionManager = (SessionManager)this.exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
                SessionConfig sessionConfig = (SessionConfig)this.exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
                if (sessionManager != null && sessionConfig != null) {
                    this.setSessionAdapter((SessionAdapter)new TowSessionAdapter(this.exchange));
                }
            } else {
                this.setSessionAdapter(this.getParentActivity().getSessionAdapter());
            }
            TowRequestAdapter requestAdapter = new TowRequestAdapter(this.getTranslet().getRequestMethod(), this.exchange);
            if (this.getParentActivity() == null) {
                String requestEncoding;
                String maxRequestSizeSetting = (String)this.getSetting(MAX_REQUEST_SIZE_SETTING_NAME);
                if (!StringUtils.isEmpty((String)maxRequestSizeSetting)) {
                    try {
                        long maxRequestSize = Long.parseLong(maxRequestSizeSetting);
                        if (maxRequestSize >= 0L) {
                            requestAdapter.setMaxRequestSize(maxRequestSize);
                            this.exchange.setMaxEntitySize(maxRequestSize);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new RequestParseException("Illegal value for maxRequestSize: " + maxRequestSizeSetting, (Throwable)e);
                    }
                }
                if ((requestEncoding = this.getIntendedRequestEncoding()) != null) {
                    try {
                        requestAdapter.setEncoding(requestEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RequestParseException("Unable to set request encoding to " + requestEncoding, (Throwable)e);
                    }
                }
            }
            this.setRequestAdapter((RequestAdapter)requestAdapter);
            TowResponseAdapter responseAdapter = new TowResponseAdapter(this.exchange, this);
            if (this.getParentActivity() == null && (responseEncoding = this.getIntendedResponseEncoding()) != null) {
                responseAdapter.setEncoding(responseEncoding);
            }
            this.setResponseAdapter((ResponseAdapter)responseAdapter);
        }
        catch (Exception e) {
            throw new AdapterException("Failed to adapt for the tow activity", (Throwable)e);
        }
        super.adapt();
    }

    protected void parseRequest() throws ActivityTerminatedException, RequestParseException {
        if (!this.isRequestParsed()) {
            if (this.getParentActivity() == null) {
                ((TowRequestAdapter)this.getRequestAdapter()).preparse();
            } else {
                ((TowRequestAdapter)this.getRequestAdapter()).preparse((TowRequestAdapter)this.getParentActivity().getRequestAdapter());
            }
            MediaType mediaType = ((TowRequestAdapter)this.getRequestAdapter()).getMediaType();
            if (mediaType != null) {
                if (WebRequestBodyParser.isMultipartForm((MethodType)this.getRequestAdapter().getRequestMethod(), (MediaType)mediaType)) {
                    this.parseMultipartFormData();
                } else if (WebRequestBodyParser.isURLEncodedForm((MediaType)mediaType)) {
                    this.parseURLEncodedFormData();
                }
            }
        }
        super.parseRequest();
    }

    private void parseMultipartFormData() throws MultipartRequestParseException {
        String multipartFormDataParser = (String)this.getSetting(MULTIPART_FORM_DATA_PARSER_SETTING_NAME);
        if (multipartFormDataParser == null) {
            throw new MultipartRequestParseException("The setting name 'multipartFormDataParser' for multipart form data parsing is not specified. Please specify 'multipartFormDataParser' via Aspect so that Translet can parse multipart form data.");
        }
        MultipartFormDataParser parser = (MultipartFormDataParser)this.getBean(multipartFormDataParser);
        if (parser == null) {
            throw new MultipartRequestParseException("No bean named '" + multipartFormDataParser + "' is defined");
        }
        parser.parse(this.getRequestAdapter());
    }

    private void parseURLEncodedFormData() throws RequestParseException {
        WebRequestBodyParser.parseURLEncodedFormData((RequestAdapter)this.getRequestAdapter());
    }

    protected LocaleResolver resolveLocale() {
        String localeChangeInterceptorId;
        LocaleResolver localeResolver = super.resolveLocale();
        if (localeResolver != null && (localeChangeInterceptorId = (String)this.getSetting("localeChangeInterceptor")) != null) {
            LocaleChangeInterceptor localeChangeInterceptor = (LocaleChangeInterceptor)this.getBean(LocaleChangeInterceptor.class, localeChangeInterceptorId);
            localeChangeInterceptor.handle(this.getTranslet(), localeResolver);
        }
        return localeResolver;
    }
}

