/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server;

import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.undertow.server.AbstractTowServer;
import com.aspectran.undertow.server.TowServer;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.servlet.api.DeploymentManager;

public class DefaultTowServer
extends AbstractTowServer
implements InitializableBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTowServer.class);
    private Undertow server;

    public void doStart() throws Exception {
        try {
            this.server = this.getBuilder().build();
            this.server.start();
            logger.info("Undertow " + TowServer.getVersion() + " started");
        }
        catch (Exception e) {
            try {
                if (this.server != null) {
                    this.server.stop();
                    this.server = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("Unable to start Undertow server", e);
        }
    }

    public void doStop() {
        if (this.server != null) {
            try {
                HttpHandler httpHandler = this.getHandler();
                if (httpHandler instanceof GracefulShutdownHandler) {
                    GracefulShutdownHandler shutdownHandler = (GracefulShutdownHandler)httpHandler;
                    shutdownHandler.shutdown();
                    try {
                        if (this.getShutdownTimeoutSecs() > 0) {
                            boolean result = shutdownHandler.awaitShutdown((long)this.getShutdownTimeoutSecs() * 1000L);
                            if (!result) {
                                logger.warn("Undertow server did not shut down gracefully within " + this.getShutdownTimeoutSecs() + " seconds. Proceeding with forceful shutdown");
                            }
                        } else {
                            shutdownHandler.awaitShutdown();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Unable to gracefully stop Undertow server");
                    }
                }
                if (this.getServletContainer() != null) {
                    for (String deploymentName : this.getServletContainer().listDeployments()) {
                        DeploymentManager manager = this.getServletContainer().getDeployment(deploymentName);
                        if (manager == null) continue;
                        manager.stop();
                        manager.undeploy();
                    }
                }
                this.server.stop();
                this.server = null;
                logger.info("Undertow " + TowServer.getVersion() + " stopped");
            }
            catch (Exception e) {
                logger.error("Unable to stop Undertow server", (Throwable)e);
            }
        }
    }

    public void initialize() throws Exception {
        if (this.isAutoStart()) {
            this.start();
        }
    }

    public void destroy() {
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.error("Error while stopping Undertow server", (Throwable)e);
        }
    }
}

