/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler;

import com.aspectran.undertow.service.TowService;
import com.aspectran.utils.annotation.jsr305.NonNull;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;

public class LightRequestHandler
implements HttpHandler {
    private final TowService towService;
    private final SessionManager sessionManager;
    private final SessionConfig sessionConfig;

    public LightRequestHandler(TowService towService) {
        this(towService, null);
    }

    public LightRequestHandler(TowService towService, SessionManager sessionManager) {
        this(towService, sessionManager, null);
    }

    public LightRequestHandler(TowService towService, SessionManager sessionManager, SessionConfig sessionConfig) {
        this.towService = towService;
        this.sessionManager = sessionManager;
        this.sessionConfig = sessionManager != null ? (sessionConfig != null ? sessionConfig : new SessionCookieConfig()) : null;
    }

    public void handleRequest(@NonNull HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
        } else {
            boolean processed;
            if (this.sessionManager != null) {
                exchange.putAttachment(SessionManager.ATTACHMENT_KEY, (Object)this.sessionManager);
                exchange.putAttachment(SessionConfig.ATTACHMENT_KEY, (Object)this.sessionConfig);
                UpdateLastAccessTimeListener listener = new UpdateLastAccessTimeListener(this.sessionManager, this.sessionConfig);
                exchange.addExchangeCompleteListener((ExchangeCompletionListener)listener);
            }
            if (!(processed = this.towService.service(exchange))) {
                ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
            }
        }
    }

    private static class UpdateLastAccessTimeListener
    implements ExchangeCompletionListener {
        private final SessionManager sessionManager;
        private final SessionConfig sessionConfig;

        private UpdateLastAccessTimeListener(SessionManager sessionManager, SessionConfig sessionConfig) {
            this.sessionManager = sessionManager;
            this.sessionConfig = sessionConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener next) {
            try {
                Session session = this.sessionManager.getSession(exchange, this.sessionConfig);
                if (session != null) {
                    session.requestDone(exchange);
                }
            }
            finally {
                next.proceed();
            }
        }
    }
}

