/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler;

import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.service.CoreService;
import com.aspectran.undertow.server.TowServer;
import com.aspectran.undertow.server.handler.AbstractRequestHandlerFactory;
import com.aspectran.undertow.server.handler.LightRequestHandler;
import com.aspectran.undertow.server.handler.resource.TowResourceHandler;
import com.aspectran.undertow.service.DefaultTowService;
import com.aspectran.undertow.service.TowService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.lifecycle.LifeCycle;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;

public class LightRequestHandlerFactory
extends AbstractRequestHandlerFactory
implements DisposableBean {
    private TowServer towServer;
    private ResourceManager resourceManager;
    private SessionManager sessionManager;
    private SessionConfig sessionConfig;
    private AspectranConfig aspectranConfig;
    private TowService towService;

    public void setTowServer(TowServer towServer) {
        this.towServer = towServer;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public void setAspectranConfig(AspectranConfig aspectranConfig) {
        this.aspectranConfig = aspectranConfig;
    }

    public HttpHandler createHandler() throws Exception {
        LightRequestHandler requestHandler;
        TowService towService = this.createTowService();
        if (this.sessionManager != null) {
            this.sessionManager.start();
        }
        Object rootHandler = requestHandler = new LightRequestHandler(towService, this.sessionManager, this.sessionConfig);
        if (this.resourceManager != null) {
            TowResourceHandler towResourceHandler = new TowResourceHandler(this.resourceManager, (HttpHandler)requestHandler);
            towResourceHandler.autoDetect(null);
            if (towResourceHandler.hasPatterns()) {
                rootHandler = towResourceHandler;
            }
        }
        return this.wrapHandler((HttpHandler)rootHandler);
    }

    private TowService createTowService() throws Exception {
        Assert.state((this.towService == null ? 1 : 0) != 0, (String)"TowService is already configured");
        CoreService rootService = this.getActivityContext().getRootService();
        if (this.aspectranConfig == null) {
            this.towService = DefaultTowService.create(rootService);
        } else {
            String basePath;
            ContextConfig contextConfig = this.aspectranConfig.getContextConfig();
            if (contextConfig != null && (basePath = contextConfig.getBasePath()) == null) {
                contextConfig.setBasePath(this.getActivityContext().getApplicationAdapter().getBasePath());
            }
            this.towService = DefaultTowService.create(this.aspectranConfig);
        }
        if (this.towService.isLateStart()) {
            this.towService.getServiceController().start();
        }
        if (this.towServer != null) {
            this.towServer.addLifeCycleListener(new LifeCycle.Listener(){

                public void lifeCycleStopping(LifeCycle event) {
                    LightRequestHandlerFactory.this.destroyTowService();
                }
            });
        }
        return this.towService;
    }

    private void destroyTowService() {
        if (this.towService != null) {
            if (this.towService.getServiceController().isActive()) {
                this.towService.getServiceController().stop();
                if (this.towService.isDerived()) {
                    this.towService.leaveFromRootService();
                }
            }
            this.towService = null;
        }
    }

    public void destroy() throws Exception {
        this.destroyTowService();
        if (this.sessionManager != null) {
            this.sessionManager.stop();
        }
    }
}

