/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler.resource;

import com.aspectran.undertow.server.handler.resource.ResourcePathPatterns;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.wildcard.PluralWildcardPattern;
import com.aspectran.utils.wildcard.WildcardPattern;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.ResourceSupplier;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class TowResourceHandler
extends ResourceHandler {
    private static final Logger logger = LoggerFactory.getLogger(TowResourceHandler.class);
    private final HttpHandler next;
    private volatile PluralWildcardPattern resourcePathPatterns;

    public TowResourceHandler(ResourceManager resourceManager) {
        this(resourceManager, null);
    }

    public TowResourceHandler(ResourceManager resourceManager, HttpHandler next) {
        super(resourceManager);
        this.next = next;
    }

    public TowResourceHandler(ResourceSupplier resourceSupplier) {
        this(resourceSupplier, null);
    }

    public TowResourceHandler(ResourceSupplier resourceSupplier, HttpHandler next) {
        super(resourceSupplier);
        this.next = next;
    }

    public synchronized void setResourcePathPatterns(@NonNull ResourcePathPatterns resourcePathPatterns) {
        String[] includePatterns = resourcePathPatterns.getIncludePatterns();
        String[] excludePatterns = resourcePathPatterns.getExcludePatterns();
        this.resourcePathPatterns = new PluralWildcardPattern(includePatterns, excludePatterns, '/');
    }

    /*
     * WARNING - void declaration
     */
    public void autoDetect(String pathPrefix) throws IOException {
        ResourceManager resourceManager = this.getResourceManager();
        if (resourceManager instanceof PathResourceManager) {
            PathResourceManager pathResourceManager = (PathResourceManager)resourceManager;
            Set<String> staticResources = this.findStaticResources(pathResourceManager.getBasePath());
            LinkedHashSet<WildcardPattern> patterns = new LinkedHashSet<WildcardPattern>();
            if (this.resourcePathPatterns != null && this.resourcePathPatterns.hasIncludePatterns()) {
                for (WildcardPattern pattern : this.resourcePathPatterns.getIncludePatterns()) {
                    boolean exists = false;
                    for (String resource : staticResources) {
                        if (!resource.endsWith("/") || !pattern.toString().startsWith(resource)) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    patterns.add(pattern);
                }
            }
            for (String string : staticResources) {
                void var6_9;
                if (StringUtils.hasLength((String)pathPrefix)) {
                    String string2 = pathPrefix + string;
                }
                if (var6_9.endsWith("/")) {
                    patterns.add(WildcardPattern.compile((String)((String)var6_9 + "**"), (char)'/'));
                    continue;
                }
                patterns.add(WildcardPattern.compile((String)var6_9));
            }
            if (patterns.isEmpty()) {
                this.resourcePathPatterns = null;
            } else {
                Object[] includePatterns = patterns.toArray(new WildcardPattern[0]);
                Object[] objectArray = this.resourcePathPatterns != null ? this.resourcePathPatterns.getExcludePatterns() : null;
                this.resourcePathPatterns = new PluralWildcardPattern((WildcardPattern[])includePatterns, (WildcardPattern[])objectArray);
                logger.info("TowResourceHandler includePatterns=" + Arrays.toString(includePatterns));
                if (objectArray != null) {
                    logger.info("TowResourceHandler excludePatterns=" + Arrays.toString(objectArray));
                }
            }
        }
    }

    @NonNull
    private Set<String> findStaticResources(Path base) throws IOException {
        HashSet<String> resources = new HashSet<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(base);){
            for (Path child : stream) {
                String fileName = child.getFileName().toString();
                if ("WEB-INF".equalsIgnoreCase(fileName) || "META-INF".equalsIgnoreCase(fileName)) {
                    resources.add("/" + fileName + "/");
                    continue;
                }
                if (Files.isDirectory(child, new LinkOption[0])) {
                    this.findStaticResourceDirs(child, "/" + fileName + "/", resources);
                    continue;
                }
                resources.add("/" + fileName);
            }
        }
        return resources;
    }

    private void findStaticResourceDirs(Path parent, String prefix, Set<String> resources) throws IOException {
        HashSet<Path> children = new HashSet<Path>();
        boolean found = false;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(parent);){
            for (Path child : stream) {
                if (Files.isDirectory(child, new LinkOption[0])) {
                    children.add(child);
                    continue;
                }
                children.clear();
                found = true;
                break;
            }
        }
        if (found) {
            resources.add(prefix);
        } else if (!children.isEmpty()) {
            for (Path child : children) {
                this.findStaticResourceDirs(child, prefix + child.getFileName() + "/", resources);
            }
        }
    }

    public boolean hasPatterns() {
        return this.resourcePathPatterns != null;
    }

    public void handleRequest(@NonNull HttpServerExchange exchange) throws Exception {
        String requestPath = exchange.getRequestPath();
        if (this.next == null || this.resourcePathPatterns != null && this.resourcePathPatterns.matches(requestPath)) {
            super.handleRequest(exchange);
        } else {
            this.next.handleRequest(exchange);
        }
    }
}

