/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.undertow.server.servlet.TowTldScanner;
import com.aspectran.utils.ResourceUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.jasper.servlet.JasperInitializer;
import org.apache.jasper.servlet.TldScanner;

public class TowJasperInitializer
extends JasperInitializer
implements ActivityContextAware {
    private static final Logger logger = LoggerFactory.getLogger(TowJasperInitializer.class);
    private ActivityContext context;
    private URL[] tldResources;

    @AvoidAdvice
    public void setActivityContext(@NonNull ActivityContext context) {
        this.context = context;
    }

    public void setTldResources(String[] resourcesToTldScan) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Specified TLD resources: " + Arrays.toString(resourcesToTldScan));
        }
        ArrayList<URL> tldResources = new ArrayList<URL>();
        if (resourcesToTldScan != null) {
            for (String resource : resourcesToTldScan) {
                if (resource == null) continue;
                tldResources.add(this.getURL(resource));
            }
        }
        this.tldResources = !tldResources.isEmpty() ? tldResources.toArray(new URL[0]) : null;
    }

    protected TldScanner newTldScanner(ServletContext context, boolean namespaceAware, boolean validate, boolean blockExternal) {
        TowTldScanner tldScanner = new TowTldScanner(context, namespaceAware, validate, blockExternal);
        tldScanner.setClassLoader(context.getClassLoader());
        tldScanner.setTldResources(this.tldResources);
        return tldScanner;
    }

    private URL getURL(@NonNull String resourceLocation) throws FileNotFoundException {
        try {
            if (resourceLocation.startsWith("classpath:")) {
                return ResourceUtils.getURL((String)resourceLocation, (ClassLoader)this.context.getClassLoader());
            }
            File file = this.context.getApplicationAdapter().toRealPathAsFile(resourceLocation);
            return file.toURI().toURL();
        }
        catch (IOException ex) {
            throw new FileNotFoundException("In TLD scanning, the supplied resource '" + resourceLocation + "' does not exist");
        }
    }
}

