/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.session;

import com.aspectran.core.component.session.Session;
import com.aspectran.undertow.server.session.TowSessionBridge;
import com.aspectran.undertow.server.session.TowSessionManager;
import com.aspectran.utils.annotation.jsr305.Nullable;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.handlers.ServletRequestContext;

final class TowSessionListenerBridge
implements com.aspectran.core.component.session.SessionListener {
    private final SessionListener listener;
    private final TowSessionManager towSessionManager;

    TowSessionListenerBridge(SessionListener listener, TowSessionManager towSessionManager) {
        this.listener = listener;
        this.towSessionManager = towSessionManager;
    }

    public void sessionCreated(com.aspectran.core.component.session.Session session) {
        this.listener.sessionCreated((Session)this.wrapSession(session), TowSessionListenerBridge.getCurrentExchange());
    }

    public void sessionDestroyed(com.aspectran.core.component.session.Session session) {
        SessionListener.SessionDestroyedReason reason = null;
        if (session != null && session.getDestroyedReason() != null) {
            reason = switch (session.getDestroyedReason()) {
                default -> throw new IncompatibleClassChangeError();
                case Session.DestroyedReason.INVALIDATED -> SessionListener.SessionDestroyedReason.INVALIDATED;
                case Session.DestroyedReason.TIMEOUT -> SessionListener.SessionDestroyedReason.TIMEOUT;
                case Session.DestroyedReason.UNDEPLOY -> SessionListener.SessionDestroyedReason.UNDEPLOY;
            };
        }
        this.listener.sessionDestroyed((Session)this.wrapSession(session), TowSessionListenerBridge.getCurrentExchange(), reason);
    }

    public void attributeAdded(com.aspectran.core.component.session.Session session, String name, Object value) {
        this.listener.attributeAdded((Session)this.wrapSession(session), name, value);
    }

    public void attributeUpdated(com.aspectran.core.component.session.Session session, String name, Object newValue, Object oldValue) {
        this.listener.attributeUpdated((Session)this.wrapSession(session), name, newValue, oldValue);
    }

    public void attributeRemoved(com.aspectran.core.component.session.Session session, String name, Object oldValue) {
        this.listener.attributeRemoved((Session)this.wrapSession(session), name, oldValue);
    }

    public void sessionIdChanged(com.aspectran.core.component.session.Session session, String oldSessionId) {
        this.listener.sessionIdChanged((Session)this.wrapSession(session), oldSessionId);
    }

    private TowSessionBridge wrapSession(com.aspectran.core.component.session.Session session) {
        return this.towSessionManager.createTowSessionBridge(session);
    }

    @Nullable
    static HttpServerExchange getCurrentExchange() {
        ServletRequestContext current = ServletRequestContext.current();
        return current != null ? current.getExchange() : null;
    }
}

