/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.session;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.component.session.DefaultSession;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionStore;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.undertow.server.session.TowSessionBridge;
import com.aspectran.undertow.server.session.TowSessionListenerBridge;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.server.session.SessionManagerStatistics;
import io.undertow.util.AttachmentKey;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TowSessionManager
implements SessionManager,
ApplicationAdapterAware,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(TowSessionManager.class);
    private final AttachmentKey<TowSessionBridge> SESSION_BRIDGE = AttachmentKey.create(TowSessionBridge.class);
    private final Map<SessionListener, TowSessionListenerBridge> sessionListenerMappings = new ConcurrentHashMap<SessionListener, TowSessionListenerBridge>();
    private final DefaultSessionManager sessionManager = new DefaultSessionManager();

    public void setApplicationAdapter(ApplicationAdapter applicationAdapter) {
        this.sessionManager.setApplicationAdapter(applicationAdapter);
    }

    public void setSessionManagerConfig(SessionManagerConfig sessionManagerConfig) {
        this.sessionManager.setSessionManagerConfig(sessionManagerConfig);
    }

    public void setSessionManagerConfigWithApon(String apon) {
        SessionManagerConfig sessionManagerConfig = new SessionManagerConfig();
        try {
            sessionManagerConfig.readFrom(apon);
        }
        catch (AponParseException e) {
            throw new RuntimeException(e);
        }
        this.setSessionManagerConfig(sessionManagerConfig);
    }

    public void setSessionStore(SessionStore sessionStore) {
        this.sessionManager.setSessionStore(sessionStore);
    }

    public SessionHandler getSessionHandler() {
        return this.sessionManager.getSessionHandler();
    }

    public String getDeploymentName() {
        return this.sessionManager.getWorkerName();
    }

    public void start() {
        try {
            if (!this.sessionManager.isInitialized()) {
                this.sessionManager.initialize();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing TowSessionManager", e);
        }
    }

    public void stop() {
        try {
            if (!this.sessionManager.isAvailable()) {
                this.sessionManager.destroy();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error destroying TowSessionManager", e);
        }
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public Session createSession(HttpServerExchange exchange, SessionConfig sessionConfig) {
        String sessionId;
        if (exchange == null) {
            throw new IllegalArgumentException("exchange must not be null");
        }
        if (sessionConfig == null) {
            throw new IllegalArgumentException("sessionConfig must not be null");
        }
        try {
            sessionId = sessionConfig.findSessionId(exchange);
        }
        catch (Exception e) {
            logger.error("Unable to create new session due to failure to find session ID", (Throwable)e);
            return null;
        }
        if (sessionId == null) {
            sessionId = this.sessionManager.createSessionId((long)this.hashCode());
        }
        DefaultSession session = this.sessionManager.createSession(sessionId);
        TowSessionBridge sessionBridge = this.createTowSessionBridge((com.aspectran.core.component.session.Session)session);
        sessionConfig.setSessionId(exchange, session.getId());
        exchange.putAttachment(this.SESSION_BRIDGE, (Object)sessionBridge);
        return sessionBridge;
    }

    public Session getSession(HttpServerExchange exchange, SessionConfig sessionConfig) {
        String sessionId;
        if (exchange == null) {
            throw new IllegalArgumentException("exchange must not be null");
        }
        if (sessionConfig == null) {
            throw new IllegalArgumentException("sessionConfig must not be null");
        }
        TowSessionBridge bridged = (TowSessionBridge)exchange.getAttachment(this.SESSION_BRIDGE);
        if (bridged != null) {
            return bridged;
        }
        try {
            sessionId = sessionConfig.findSessionId(exchange);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve session due to failure to find session ID", (Throwable)e);
            return null;
        }
        TowSessionBridge sessionBridge = (TowSessionBridge)this.getSession(sessionId);
        if (sessionBridge != null) {
            exchange.putAttachment(this.SESSION_BRIDGE, (Object)sessionBridge);
            sessionBridge.requestStarted(exchange);
        }
        return sessionBridge;
    }

    public Session getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        DefaultSession session = this.sessionManager.getSession(sessionId);
        if (session != null) {
            return this.createTowSessionBridge((com.aspectran.core.component.session.Session)session);
        }
        return null;
    }

    public void registerSessionListener(SessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        TowSessionListenerBridge sessionListenerBridge = new TowSessionListenerBridge(listener, this);
        this.sessionListenerMappings.put(listener, sessionListenerBridge);
        this.sessionManager.addSessionListener((com.aspectran.core.component.session.SessionListener)sessionListenerBridge);
    }

    public void removeSessionListener(SessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        TowSessionListenerBridge sessionListenerBridge = this.sessionListenerMappings.remove(listener);
        if (sessionListenerBridge != null) {
            this.sessionManager.removeSessionListener((com.aspectran.core.component.session.SessionListener)sessionListenerBridge);
        }
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.sessionManager.setDefaultMaxIdleSecs(timeout);
    }

    public Set<String> getTransientSessions() {
        return Collections.emptySet();
    }

    public Set<String> getActiveSessions() {
        return this.getSessionHandler().getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.getSessionHandler().getAllSessions();
    }

    public SessionManagerStatistics getStatistics() {
        return new SessionManagerStatistics(){

            public long getCreatedSessionCount() {
                return TowSessionManager.this.sessionManager.getStatistics().getCreatedSessions();
            }

            public long getMaxActiveSessions() {
                return TowSessionManager.this.sessionManager.getSessionCache().getMaxActiveSessions();
            }

            public long getHighestSessionCount() {
                return TowSessionManager.this.sessionManager.getStatistics().getHighestActiveSessions();
            }

            public long getActiveSessionCount() {
                return TowSessionManager.this.sessionManager.getStatistics().getActiveSessions();
            }

            public long getExpiredSessionCount() {
                return TowSessionManager.this.sessionManager.getStatistics().getExpiredSessions();
            }

            public long getRejectedSessions() {
                return TowSessionManager.this.sessionManager.getStatistics().getRejectedSessions();
            }

            public long getMaxSessionAliveTime() {
                return TowSessionManager.this.sessionManager.getStatistics().getSessionTimeMax();
            }

            public long getAverageSessionAliveTime() {
                return TowSessionManager.this.sessionManager.getStatistics().getSessionTimeMean();
            }

            public long getStartTime() {
                return TowSessionManager.this.sessionManager.getStatistics().getStartTime();
            }
        };
    }

    TowSessionBridge createTowSessionBridge(com.aspectran.core.component.session.Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        return new TowSessionBridge(session, this);
    }
}

