/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.service;

import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.request.RequestMethodNotAllowedException;
import com.aspectran.core.activity.request.SizeLimitExceededException;
import com.aspectran.core.component.session.MaxSessionsExceededException;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ExposalsConfig;
import com.aspectran.core.context.config.WebConfig;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.undertow.activity.TowActivity;
import com.aspectran.undertow.service.AbstractTowService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.support.http.HttpStatus;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.net.URLDecoder;

public class DefaultTowService
extends AbstractTowService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTowService.class);
    private boolean trailingSlashRedirect;
    private volatile long pauseTimeout = -2L;

    public DefaultTowService() {
    }

    public DefaultTowService(CoreService rootService) {
        super(rootService);
    }

    public void setTrailingSlashRedirect(boolean trailingSlashRedirect) {
        this.trailingSlashRedirect = trailingSlashRedirect;
    }

    @Override
    public boolean service(@NonNull HttpServerExchange exchange) throws IOException {
        TransletRule transletRule;
        MethodType requestMethod;
        String requestPath = exchange.getRequestPath();
        if (this.getUriDecoding() != null) {
            requestPath = URLDecoder.decode(requestPath, this.getUriDecoding());
        }
        if (!this.isExposable(requestPath)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getRequestInfo(exchange));
        }
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.getServiceName() + " has been paused, so did not respond to request " + requestPath);
                }
                exchange.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE.value());
                return true;
            }
            if (this.pauseTimeout == -2L) {
                logger.warn(this.getServiceName() + " is not yet started");
                exchange.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE.value());
                exchange.setReasonPhrase("Starting... Try again in a moment.");
                return true;
            }
            this.pauseTimeout = 0L;
        }
        if ((requestMethod = MethodType.resolve((String)exchange.getRequestMethod().toString())) == null) {
            requestMethod = MethodType.GET;
        }
        if ((transletRule = this.getActivityContext().getTransletRuleRegistry().getTransletRule(requestPath, requestMethod)) == null) {
            if (this.trailingSlashRedirect && requestMethod == MethodType.GET && StringUtils.startsWith((String)requestPath, (char)'/') && !StringUtils.endsWith((String)requestPath, (char)'/')) {
                String transletNameWithSlash = requestPath + "/";
                if (this.getActivityContext().getTransletRuleRegistry().contains(transletNameWithSlash, requestMethod)) {
                    exchange.setStatusCode(HttpStatus.MOVED_PERMANENTLY.value());
                    exchange.getResponseHeaders().put(Headers.LOCATION, transletNameWithSlash);
                    exchange.getResponseHeaders().put(Headers.CONNECTION, "close");
                    if (logger.isTraceEnabled()) {
                        logger.trace("Redirect URL with a Trailing Slash: " + requestPath);
                    }
                    return true;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("No translet mapped for " + requestMethod + " " + requestPath);
            }
            exchange.setStatusCode(HttpStatus.NOT_FOUND.value());
            return true;
        }
        this.perform(exchange, requestPath, requestMethod, transletRule);
        return true;
    }

    private void perform(HttpServerExchange exchange, String requestPath, MethodType requestMethod, TransletRule transletRule) {
        TowActivity activity = null;
        try {
            activity = new TowActivity(this, exchange);
            activity.prepare(requestPath, requestMethod, transletRule);
            activity.perform();
        }
        catch (ActivityTerminatedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Activity terminated: " + e.getMessage());
            }
        }
        catch (Exception e) {
            Throwable t = activity != null && activity.getRaisedException() != null ? activity.getRaisedException() : e;
            Throwable cause = ExceptionUtils.getRootCause((Throwable)t);
            logger.error("Error occurred while processing request: " + requestMethod + " " + requestPath, t);
            if (cause instanceof RequestMethodNotAllowedException) {
                this.sendError(exchange, HttpStatus.METHOD_NOT_ALLOWED.value(), null);
            }
            if (cause instanceof SizeLimitExceededException) {
                this.sendError(exchange, HttpStatus.PAYLOAD_TOO_LARGE.value(), null);
            }
            if (cause instanceof MaxSessionsExceededException) {
                this.sendError(exchange, HttpStatus.SERVICE_UNAVAILABLE.value(), "Max Sessions Exceeded");
            }
            this.sendError(exchange, HttpStatus.INTERNAL_SERVER_ERROR.value(), null);
        }
    }

    private void sendError(HttpServerExchange exchange, int sc, String msg) {
        ToStringBuilder tsb = new ToStringBuilder("Send error response");
        tsb.append("code", (Object)sc);
        tsb.append("message", (Object)msg);
        logger.error(tsb.toString());
        if (msg != null) {
            exchange.setStatusCode(sc);
            exchange.setReasonPhrase(msg);
        } else {
            exchange.setStatusCode(sc);
        }
    }

    @NonNull
    private String getRequestInfo(@NonNull HttpServerExchange exchange) {
        StringBuilder sb = new StringBuilder();
        sb.append(exchange.getRequestMethod()).append(" ");
        sb.append(exchange.getRequestURI()).append(" ");
        sb.append(exchange.getProtocol()).append(" ");
        String remoteAddr = exchange.getRequestHeaders().getFirst("X-Forwarded-For");
        if (!StringUtils.isEmpty((String)remoteAddr)) {
            sb.append(remoteAddr);
        } else {
            sb.append(exchange.getSourceAddress());
        }
        return sb.toString();
    }

    @NonNull
    public static DefaultTowService create(CoreService rootService) {
        WebConfig webConfig;
        Assert.notNull((Object)rootService, (String)"rootService must not be null");
        DefaultTowService towService = new DefaultTowService(rootService);
        AspectranConfig aspectranConfig = rootService.getAspectranConfig();
        if (aspectranConfig != null && (webConfig = aspectranConfig.getWebConfig()) != null) {
            DefaultTowService.configure(towService, webConfig);
        }
        DefaultTowService.setServiceStateListener(towService);
        return towService;
    }

    @NonNull
    public static DefaultTowService create(AspectranConfig aspectranConfig) {
        Assert.notNull((Object)aspectranConfig, (String)"aspectranConfig must not be null");
        DefaultTowService towService = new DefaultTowService();
        towService.configure(aspectranConfig);
        WebConfig webConfig = aspectranConfig.getWebConfig();
        if (webConfig != null) {
            DefaultTowService.configure(towService, webConfig);
        }
        DefaultTowService.setServiceStateListener(towService);
        return towService;
    }

    private static void configure(@NonNull DefaultTowService towService, @NonNull WebConfig webConfig) {
        towService.setUriDecoding(webConfig.getUriDecoding());
        towService.setTrailingSlashRedirect(webConfig.isTrailingSlashRedirect());
        ExposalsConfig exposalsConfig = webConfig.getExposalsConfig();
        if (exposalsConfig != null) {
            String[] includePatterns = exposalsConfig.getIncludePatterns();
            String[] excludePatterns = exposalsConfig.getExcludePatterns();
            towService.setExposals(includePatterns, excludePatterns);
        }
    }

    private static void setServiceStateListener(final @NonNull DefaultTowService towService) {
        towService.setServiceStateListener(new ServiceStateListener(){

            public void started() {
                towService.pauseTimeout = 0L;
            }

            public void restarted() {
                this.started();
            }

            public void paused(long millis) {
                if (millis > 0L) {
                    towService.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    logger.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            public void paused() {
                towService.pauseTimeout = -1L;
            }

            public void resumed() {
                this.started();
            }

            public void stopped() {
                this.paused();
            }
        });
    }
}

