/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.adapter;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.adapter.AbstractResponseAdapter;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.undertow.activity.TowActivity;
import com.aspectran.utils.Assert;
import com.aspectran.web.adapter.HttpServletResponseAdapter;
import com.aspectran.web.support.http.HttpStatus;
import com.aspectran.web.support.http.MediaType;
import com.aspectran.web.support.util.SendRedirectBasedOnXForwardedProtocol;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.URLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.stream.Collectors;

public class TowResponseAdapter
extends AbstractResponseAdapter {
    private final TowActivity activity;
    private String contentType;
    private String charset;
    private Writer writer;
    private ResponseState responseState = ResponseState.NONE;

    public TowResponseAdapter(HttpServerExchange exchange, TowActivity activity) {
        super((Object)exchange);
        this.activity = activity;
    }

    public String getHeader(String name) {
        return this.getHttpServerExchange().getResponseHeaders().getFirst(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.getHttpServerExchange().getResponseHeaders().get(name);
    }

    public Collection<String> getHeaderNames() {
        return this.getHttpServerExchange().getResponseHeaders().getHeaderNames().stream().map(HttpString::toString).collect(Collectors.toSet());
    }

    public boolean containsHeader(String name) {
        return this.getHttpServerExchange().getResponseHeaders().contains(name);
    }

    public void setHeader(String name, String value) {
        this.setHeader(HttpString.tryFromString((String)name), value);
    }

    private void setHeader(HttpString name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name must not be null");
        }
        if (name.equals(Headers.CONTENT_TYPE)) {
            this.setContentType(value);
        } else {
            this.getHttpServerExchange().getResponseHeaders().put(name, value);
        }
    }

    public void addHeader(String name, String value) {
        this.addHeader(HttpString.tryFromString((String)name), value);
    }

    private void addHeader(HttpString name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name must not be null");
        }
        if (name.equals(Headers.CONTENT_TYPE) && !this.getHttpServerExchange().getResponseHeaders().contains(Headers.CONTENT_TYPE)) {
            this.setContentType(value);
        } else {
            this.getHttpServerExchange().getResponseHeaders().add(name, value);
        }
    }

    public String getEncoding() {
        if (this.charset != null) {
            return this.charset;
        }
        return StandardCharsets.ISO_8859_1.name();
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.charset = encoding;
        if (this.contentType != null) {
            this.getHttpServerExchange().getResponseHeaders().put(Headers.CONTENT_TYPE, this.getContentType());
        }
    }

    public String getContentType() {
        if (this.contentType != null) {
            if (this.charset != null) {
                return this.contentType + ";charset=" + this.charset;
            }
            return this.contentType;
        }
        return null;
    }

    public void setContentType(String contentType) {
        if (contentType == null) {
            return;
        }
        MediaType type = MediaType.parseMediaType((String)contentType);
        String charset = type.getParameter("charset");
        this.contentType = type.getType() + "/" + type.getSubtype();
        if (charset != null) {
            this.charset = charset;
        }
        if (this.charset != null) {
            String fullContentType = this.contentType + "; charset=" + this.charset;
            this.getHttpServerExchange().getResponseHeaders().put(Headers.CONTENT_TYPE, fullContentType);
        } else {
            this.getHttpServerExchange().getResponseHeaders().put(Headers.CONTENT_TYPE, this.contentType);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        Assert.state((this.responseState != ResponseState.WRITER ? 1 : 0) != 0, (String)"Cannot call getOutputStream(), getWriter() already called");
        this.responseState = ResponseState.STREAM;
        this.ifStartBlocking();
        return this.getHttpServerExchange().getOutputStream();
    }

    public Writer getWriter() throws IOException {
        if (this.writer == null) {
            Assert.state((this.responseState != ResponseState.STREAM ? 1 : 0) != 0, (String)"Cannot call getWriter(), getOutputStream() already called");
            this.responseState = ResponseState.WRITER;
            this.ifStartBlocking();
            this.writer = new OutputStreamWriter(this.getHttpServerExchange().getOutputStream(), this.getEncoding());
        }
        return this.writer;
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.getHttpServerExchange().isBlocking() && this.getHttpServerExchange().isResponseStarted()) {
            this.getHttpServerExchange().getOutputStream().flush();
        }
    }

    public void redirect(String location) throws IOException {
        this.setStatus(HttpStatus.FOUND.value());
        if (URLUtils.isAbsoluteUrl((String)location)) {
            this.getHttpServerExchange().getResponseHeaders().put(Headers.LOCATION, location);
        } else {
            Translet translet;
            String locationForwarded;
            boolean proxyProtocolAware = Boolean.parseBoolean((String)this.activity.getSetting("proxyProtocolAware"));
            if (proxyProtocolAware && (locationForwarded = SendRedirectBasedOnXForwardedProtocol.getLocationForwarded((Translet)(translet = this.activity.getTranslet()), (String)location)) != null) {
                this.getHttpServerExchange().getResponseHeaders().put(Headers.LOCATION, locationForwarded);
                return;
            }
            String realPath = location.startsWith("/") ? location : CanonicalPathUtils.canonicalize((String)location);
            String url = this.getHttpServerExchange().getRequestScheme() + "://" + this.getHttpServerExchange().getHostAndPort() + realPath;
            this.getHttpServerExchange().getResponseHeaders().put(Headers.LOCATION, url);
        }
    }

    public String redirect(RedirectRule redirectRule) throws IOException {
        String path = HttpServletResponseAdapter.makeRedirectPath((RedirectRule)redirectRule, (Activity)this.activity);
        this.redirect(path);
        return path;
    }

    public int getStatus() {
        return this.getHttpServerExchange().getStatusCode();
    }

    public void setStatus(int status) {
        this.getHttpServerExchange().setStatusCode(status);
    }

    private void ifSetChunked() {
        HeaderMap responseHeaders = this.getHttpServerExchange().getResponseHeaders();
        if (!responseHeaders.contains(Headers.CONTENT_LENGTH)) {
            this.getHttpServerExchange().getResponseHeaders().put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
        }
    }

    private void ifStartBlocking() {
        if (!this.getHttpServerExchange().isBlocking()) {
            this.getHttpServerExchange().startBlocking();
        }
    }

    private HttpServerExchange getHttpServerExchange() {
        return (HttpServerExchange)this.getAdaptee();
    }

    public static enum ResponseState {
        NONE,
        STREAM,
        WRITER;

    }
}

