/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler;

import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.service.CoreService;
import com.aspectran.undertow.server.TowServer;
import com.aspectran.undertow.server.handler.AbstractRequestHandlerFactory;
import com.aspectran.undertow.server.handler.LightRequestHandler;
import com.aspectran.undertow.server.handler.resource.TowResourceHandler;
import com.aspectran.undertow.service.DefaultTowServiceBuilder;
import com.aspectran.undertow.service.TowService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.lifecycle.LifeCycle;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;

public class LightRequestHandlerFactory
extends AbstractRequestHandlerFactory
implements ActivityContextAware,
DisposableBean {
    private ActivityContext context;
    private TowServer towServer;
    private ResourceManager resourceManager;
    private SessionManager sessionManager;
    private SessionConfig sessionConfig;
    private AspectranConfig aspectranConfig;
    private TowService towService;

    @NonNull
    public ActivityContext getActivityContext() {
        return this.context;
    }

    @AvoidAdvice
    public void setActivityContext(@NonNull ActivityContext context) {
        this.context = context;
    }

    public void setTowServer(TowServer towServer) {
        this.towServer = towServer;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public void setAspectranConfig(AspectranConfig aspectranConfig) {
        this.aspectranConfig = aspectranConfig;
    }

    public HttpHandler createHandler() throws Exception {
        LightRequestHandler requestHandler;
        TowService towService = this.createTowService();
        if (this.sessionManager != null) {
            this.sessionManager.start();
        }
        Object rootHandler = requestHandler = new LightRequestHandler(towService, this.sessionManager, this.sessionConfig);
        if (this.resourceManager != null) {
            TowResourceHandler resourceHandler = new TowResourceHandler(this.resourceManager, (HttpHandler)requestHandler);
            resourceHandler.autoDetect(null);
            if (resourceHandler.hasPatterns()) {
                rootHandler = resourceHandler;
            }
        }
        return this.wrapHandler((HttpHandler)rootHandler);
    }

    private TowService createTowService() throws Exception {
        Assert.state((this.towService == null ? 1 : 0) != 0, (String)"TowService is already configured");
        CoreService rootService = this.getActivityContext().getRootService();
        if (this.aspectranConfig == null) {
            this.towService = DefaultTowServiceBuilder.build(rootService);
        } else {
            String basePath;
            ContextConfig contextConfig = this.aspectranConfig.getContextConfig();
            if (contextConfig != null && (basePath = contextConfig.getBasePath()) == null) {
                contextConfig.setBasePath(this.getActivityContext().getApplicationAdapter().getBasePath());
            }
            this.towService = DefaultTowServiceBuilder.build(this.aspectranConfig);
        }
        if (this.towService.isLateStart()) {
            this.towService.getServiceController().start();
        }
        if (this.towServer != null) {
            this.towServer.addLifeCycleListener(new LifeCycle.Listener(){

                public void lifeCycleStopping(LifeCycle event) {
                    LightRequestHandlerFactory.this.destroyTowService();
                }
            });
        }
        return this.towService;
    }

    private void destroyTowService() {
        if (this.towService != null) {
            if (this.towService.getServiceController().isActive()) {
                this.towService.getServiceController().stop();
                if (this.towService.isDerived()) {
                    this.towService.leaveFromRootService();
                }
            }
            this.towService = null;
        }
    }

    public void destroy() throws Exception {
        this.destroyTowService();
        if (this.sessionManager != null) {
            this.sessionManager.stop();
        }
    }
}

