/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler.accesslog;

import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.undertow.server.handler.accesslog.TowAccessLogReceiver;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;

public class AccessLogHandlerWrapper
implements ActivityContextAware,
HandlerWrapper {
    private ClassLoader classLoader;
    private String formatString;
    private String category;

    @AvoidAdvice
    public void setActivityContext(@NonNull ActivityContext context) {
        this.classLoader = context.getAvailableActivity().getClassLoader();
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return ClassUtils.getDefaultClassLoader();
        }
        return this.classLoader;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public HttpHandler wrap(HttpHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        TowAccessLogReceiver accessLogReceiver = new TowAccessLogReceiver(this.category);
        String formatString = StringUtils.hasText((String)this.formatString) ? this.formatString : "combined";
        return new AccessLogHandler(handler, (AccessLogReceiver)accessLogReceiver, formatString, this.getClassLoader());
    }
}

