/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler.encoding;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.support.http.MediaType;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.RequestHeaderAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContentEncodingPredicates {
    private static final Logger logger = LoggerFactory.getLogger(ContentEncodingPredicates.class);
    public static final long BREAK_EVEN_GZIP_SIZE = 23L;
    private long contentSizeLargerThan = 0L;
    private String[] mediaTypes;
    private String[] excludedUserAgents;

    public void setContentSizeLargerThan(long contentSizeLargerThan) {
        this.contentSizeLargerThan = contentSizeLargerThan;
    }

    public void setMediaTypes(String[] mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public void setExcludedUserAgents(String[] excludedUserAgents) {
        this.excludedUserAgents = excludedUserAgents;
    }

    @NonNull
    public Predicate createPredicate() {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (this.contentSizeLargerThan > 0L) {
            if (this.contentSizeLargerThan < 23L) {
                logger.warn("contentSizeLargerThan of " + this.contentSizeLargerThan + " is inefficient for short content, break even is size 23");
            }
            predicates.add(Predicates.requestLargerThan((long)this.contentSizeLargerThan));
        }
        if (this.mediaTypes != null && this.mediaTypes.length > 0) {
            predicates.add(new CompressibleMimeTypePredicate(this.mediaTypes));
        }
        if (this.excludedUserAgents != null) {
            for (String agent : this.excludedUserAgents) {
                RequestHeaderAttribute agentHeader = new RequestHeaderAttribute(new HttpString("User-Agent"));
                predicates.add(Predicates.not((Predicate)Predicates.regex((ExchangeAttribute)agentHeader, (String)agent)));
            }
        }
        return Predicates.and((Predicate[])predicates.toArray(new Predicate[0]));
    }

    private static class CompressibleMimeTypePredicate
    implements Predicate {
        private final List<MediaType> mediaTypes;

        private CompressibleMimeTypePredicate(@NonNull String[] mediaTypes) {
            if (mediaTypes.length == 1) {
                this.mediaTypes = Collections.singletonList(MediaType.parseMediaType((String)mediaTypes[0]));
            } else {
                this.mediaTypes = new ArrayList<MediaType>(mediaTypes.length);
                for (String mediaType : mediaTypes) {
                    this.mediaTypes.add(MediaType.parseMediaType((String)mediaType));
                }
            }
        }

        public boolean resolve(@NonNull HttpServerExchange exchange) {
            String contentType = exchange.getResponseHeaders().getFirst("Content-Type");
            if (contentType != null) {
                for (MediaType mediaType : this.mediaTypes) {
                    if (!mediaType.isCompatibleWith(MediaType.parseMediaType((String)contentType))) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

